/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import org.eclipse.core.internal.registry.KeyedElement;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class Contribution
implements KeyedElement {
    static final int[] EMPTY_CHILDREN = new int[2];
    private Bundle contributingBundle;
    private long contributingBundleId;
    private int[] children = EMPTY_CHILDREN;
    static final byte EXTENSION_POINT = 0;
    static final byte EXTENSION = 1;

    Contribution(Bundle bundle) {
        this.contributingBundle = bundle;
        this.contributingBundleId = bundle.getBundleId();
    }

    Contribution(long id) {
        this.contributingBundleId = id;
        this.contributingBundle = InternalPlatform.getDefault().getBundleContext().getBundle(this.contributingBundleId);
    }

    void setRawChildren(int[] children) {
        this.children = children;
    }

    int[] getRawChildren() {
        return this.children;
    }

    int[] getExtensions() {
        int[] results = new int[this.children[1]];
        System.arraycopy(this.children, 2 + this.children[0], results, 0, this.children[1]);
        return results;
    }

    Bundle getContributingBundle() {
        return this.contributingBundle;
    }

    int[] getExtensionPoints() {
        int[] results = new int[this.children[0]];
        System.arraycopy(this.children, 2, results, 0, this.children[0]);
        return results;
    }

    String getNamespace() {
        if (this.contributingBundle == null) {
            throw new IllegalStateException("Internal error in extension registry. The bundle corresponding to this contribution has been uninstalled.");
        }
        if (Platform.isFragment(this.contributingBundle)) {
            return Platform.getHosts(this.contributingBundle)[0].getSymbolicName();
        }
        return this.contributingBundle.getSymbolicName();
    }

    public String toString() {
        return "Contribution: " + this.contributingBundleId + " in namespace" + this.getNamespace();
    }

    Bundle getNamespaceBundle() {
        if (this.contributingBundle == null) {
            throw new IllegalStateException("Internal error in extension registry. The bundle corresponding to this contribution has been uninstalled.");
        }
        if (Platform.isFragment(this.contributingBundle)) {
            return Platform.getHosts(this.contributingBundle)[0];
        }
        return this.contributingBundle;
    }

    public int getKeyHashCode() {
        return this.getKey().hashCode();
    }

    public Object getKey() {
        return new Long(this.contributingBundleId);
    }

    public boolean compare(KeyedElement other) {
        return this.contributingBundleId == ((Contribution)other).contributingBundleId;
    }
}

