/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionsParser
extends DefaultHandler {
    private static final String NO_EXTENSION_MUNGING = "eclipse.noExtensionMunging";
    private static Map extensionPointMap;
    private static long cumulativeTime;
    private boolean compatibilityMode;
    private String locationName = null;
    private Stack stateStack = new Stack();
    private Stack objectStack = new Stack();
    private String schemaVersion = null;
    private MultiStatus status;
    private ResourceBundle resources;
    private RegistryObjectManager objectManager;
    private Contribution namespace;
    private String configurationElementValue;
    public static final int PARSE_PROBLEM = 1;
    public static final String PLUGIN = "plugin";
    public static final String PLUGIN_ID = "id";
    public static final String PLUGIN_NAME = "name";
    public static final String FRAGMENT = "fragment";
    public static final String BUNDLE_UID = "id";
    public static final String EXTENSION_POINT = "extension-point";
    public static final String EXTENSION_POINT_NAME = "name";
    public static final String EXTENSION_POINT_ID = "id";
    public static final String EXTENSION_POINT_SCHEMA = "schema";
    public static final String EXTENSION = "extension";
    public static final String EXTENSION_NAME = "name";
    public static final String EXTENSION_ID = "id";
    public static final String EXTENSION_TARGET = "point";
    public static final String ELEMENT = "element";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_VALUE = "value";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int BUNDLE_STATE = 2;
    private static final int BUNDLE_EXTENSION_POINT_STATE = 5;
    private static final int BUNDLE_EXTENSION_STATE = 6;
    private static final int CONFIGURATION_ELEMENT_STATE = 10;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private ArrayList[] scratchVectors = new ArrayList[2];
    private String manifestType;
    private Locator locator = null;

    static {
        ExtensionsParser.initializeExtensionPointMap();
        cumulativeTime = 0L;
    }

    private static void initializeExtensionPointMap() {
        HashMap<String, String> map = new HashMap<String, String>(13);
        map.put("org.eclipse.ui.markerImageProvider", "org.eclipse.ui.ide.markerImageProvider");
        map.put("org.eclipse.ui.markerHelp", "org.eclipse.ui.ide.markerHelp");
        map.put("org.eclipse.ui.markerImageProviders", "org.eclipse.ui.ide.markerImageProviders");
        map.put("org.eclipse.ui.markerResolution", "org.eclipse.ui.ide.markerResolution");
        map.put("org.eclipse.ui.projectNatureImages", "org.eclipse.ui.ide.projectNatureImages");
        map.put("org.eclipse.ui.resourceFilters", "org.eclipse.ui.ide.resourceFilters");
        map.put("org.eclipse.ui.markerUpdaters", "org.eclipse.ui.editors.markerUpdaters");
        map.put("org.eclipse.ui.documentProviders", "org.eclipse.ui.editors.documentProviders");
        map.put("org.eclipse.ui.workbench.texteditor.markerAnnotationSpecification", "org.eclipse.ui.editors.markerAnnotationSpecification");
        map.put("org.eclipse.help.browser", "org.eclipse.help.base.browser");
        map.put("org.eclipse.help.luceneAnalyzer", "org.eclipse.help.base.luceneAnalyzer");
        map.put("org.eclipse.help.webapp", "org.eclipse.help.base.webapp");
        map.put("org.eclipse.help.support", "org.eclipse.ui.helpSupport");
        extensionPointMap = map;
    }

    public ExtensionsParser(MultiStatus status) {
        this.status = status;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] ch, int start, int length) {
        int state = (Integer)this.stateStack.peek();
        if (state != 10) {
            return;
        }
        if (state == 10) {
            ConfigurationElement currentConfigElement = (ConfigurationElement)this.objectStack.peek();
            String value = new String(ch, start, length);
            if (this.configurationElementValue == null) {
                if (value.trim().length() != 0) {
                    this.configurationElementValue = value;
                }
            } else {
                this.configurationElementValue = String.valueOf(this.configurationElementValue) + value;
            }
            if (this.configurationElementValue != null) {
                currentConfigElement.setValue(this.translate(this.configurationElementValue));
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String uri, String elementName, String qName) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                this.internalError(NLS.bind((String)Messages.parse_internalStack, (Object)elementName));
                break;
            }
            case 2: {
                if (!elementName.equals(this.manifestType)) break;
                this.stateStack.pop();
                ArrayList extensionPoints = this.scratchVectors[0];
                ArrayList extensions = this.scratchVectors[1];
                int[] namespaceChildren = new int[2 + extensionPoints.size() + extensions.size()];
                int position = 2;
                if (extensionPoints.size() > 0) {
                    namespaceChildren[0] = extensionPoints.size();
                    Iterator iter = extensionPoints.iterator();
                    while (iter.hasNext()) {
                        namespaceChildren[position++] = ((RegistryObject)iter.next()).getObjectId();
                    }
                    extensionPoints.clear();
                }
                if (extensions.size() > 0) {
                    Extension[] renamedExtensions = this.fixRenamedExtensionPoints(extensions.toArray(new Extension[extensions.size()]));
                    namespaceChildren[1] = renamedExtensions.length;
                    int i = 0;
                    while (i < renamedExtensions.length) {
                        namespaceChildren[position++] = renamedExtensions[i].getObjectId();
                        ++i;
                    }
                    extensions.clear();
                }
                this.namespace.setRawChildren(namespaceChildren);
                break;
            }
            case 5: {
                if (!elementName.equals(EXTENSION_POINT)) break;
                this.stateStack.pop();
                break;
            }
            case 6: {
                if (!elementName.equals(EXTENSION)) break;
                this.stateStack.pop();
                Extension currentExtension = (Extension)this.objectStack.pop();
                currentExtension.setNamespace(this.namespace.getNamespace());
                this.scratchVectors[1].add(currentExtension);
                break;
            }
            case 10: {
                this.stateStack.pop();
                this.configurationElementValue = null;
                ConfigurationElement currentConfigElement = (ConfigurationElement)this.objectStack.pop();
                String value = currentConfigElement.getValueAsIs();
                if (value != null) {
                    currentConfigElement.setValue(value.trim());
                }
                RegistryObject parent = (RegistryObject)this.objectStack.peek();
                int[] oldValues = parent.getRawChildren();
                int size = oldValues.length;
                int[] newValues = new int[size + 1];
                int i = 0;
                while (i < size) {
                    newValues[i] = oldValues[i];
                    ++i;
                }
                newValues[size] = currentConfigElement.getObjectId();
                parent.setRawChildren(newValues);
                currentConfigElement.setParentId(parent.getObjectId());
                currentConfigElement.setParentType(parent instanceof ConfigurationElement ? (byte)1 : 2);
            }
        }
    }

    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    private void handleExtensionPointState(String elementName) {
        this.stateStack.push(new Integer(0));
        this.unknownElement(EXTENSION_POINT, elementName);
    }

    private void handleExtensionState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(10));
        this.configurationElementValue = null;
        ConfigurationElement currentConfigurationElement = new ConfigurationElement();
        currentConfigurationElement.setContributingBundle(this.namespace.getNamespaceBundle());
        this.objectStack.push(currentConfigurationElement);
        currentConfigurationElement.setName(elementName);
        this.parseConfigurationElementAttributes(attributes);
        this.objectManager.add(currentConfigurationElement, true);
    }

    private void handleInitialState(String elementName, Attributes attributes) {
        if (!elementName.equals(this.manifestType)) {
            this.stateStack.push(new Integer(0));
            this.internalError(NLS.bind((String)Messages.parse_unknownTopElement, (Object)elementName));
            return;
        }
        this.compatibilityMode = attributes.getLength() > 0;
        this.stateStack.push(new Integer(2));
        this.objectStack.push(this.namespace);
    }

    private void handleBundleState(String elementName, Attributes attributes) {
        if (elementName.equals(EXTENSION_POINT)) {
            this.stateStack.push(new Integer(5));
            this.parseExtensionPointAttributes(attributes);
            return;
        }
        if (elementName.equals(EXTENSION)) {
            this.stateStack.push(new Integer(6));
            this.parseExtensionAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        if (!this.compatibilityMode) {
            this.unknownElement(this.manifestType, elementName);
        }
    }

    private void logStatus(SAXParseException ex) {
        String name = ex.getSystemId();
        if (name == null) {
            name = this.locationName;
        }
        name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"));
        String msg = name.equals("") ? NLS.bind((String)Messages.parse_error, (Object)ex.getMessage()) : NLS.bind((String)Messages.parse_errorNameLineColumn, (Object[])new Object[]{name, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), ex.getMessage()});
        this.error(new Status(2, "org.eclipse.core.runtime", 1, msg, ex));
    }

    public Contribution parseManifest(ServiceTracker factoryTracker, InputSource in, String manifestKind, String manifestName, RegistryObjectManager registryObjects, Contribution currentNamespace, ResourceBundle bundle) throws ParserConfigurationException, SAXException, IOException {
        Contribution contribution;
        block9: {
            SAXParserFactory factory;
            long start = 0L;
            this.resources = bundle;
            this.objectManager = registryObjects;
            this.namespace = currentNamespace;
            if (InternalPlatform.DEBUG) {
                start = System.currentTimeMillis();
            }
            if ((factory = (SAXParserFactory)factoryTracker.getService()) == null) {
                throw new SAXException(Messages.parse_xmlParserNotAvailable);
            }
            try {
                if (manifestKind == null) {
                    throw new NullPointerException();
                }
                if (!manifestKind.equals(PLUGIN) && !manifestKind.equals(FRAGMENT)) {
                    throw new IllegalArgumentException("Invalid manifest type: " + this.manifestType);
                }
                this.manifestType = manifestKind;
                this.locationName = in.getSystemId();
                if (this.locationName == null) {
                    this.locationName = manifestName;
                }
                factory.setNamespaceAware(true);
                try {
                    factory.setFeature("http://xml.org/sax/features/string-interning", true);
                }
                catch (SAXException sAXException) {}
                factory.setValidating(false);
                factory.newSAXParser().parse(in, (DefaultHandler)this);
                contribution = (Contribution)this.objectStack.pop();
                Object var11_11 = null;
                if (!InternalPlatform.DEBUG) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var11_12 = null;
                    if (!InternalPlatform.DEBUG) break block10;
                    InternalPlatform.getDefault().setOption("org.eclipse.core.runtime/registry/parsing/timing/value", Long.toString(cumulativeTime += System.currentTimeMillis() - start));
                }
                throw throwable;
            }
            InternalPlatform.getDefault().setOption("org.eclipse.core.runtime/registry/parsing/timing/value", Long.toString(cumulativeTime += System.currentTimeMillis() - start));
        }
        return contribution;
    }

    private void parseConfigurationElementAttributes(Attributes attributes) {
        int len;
        ConfigurationElement parentConfigurationElement = (ConfigurationElement)this.objectStack.peek();
        int n = len = attributes != null ? attributes.getLength() : 0;
        if (len == 0) {
            parentConfigurationElement.setProperties(RegistryObjectManager.EMPTY_STRING_ARRAY);
            return;
        }
        String[] properties = new String[len * 2];
        int i = 0;
        while (i < len) {
            properties[i * 2] = attributes.getLocalName(i);
            properties[i * 2 + 1] = this.translate(attributes.getValue(i));
            ++i;
        }
        parentConfigurationElement.setProperties(properties);
        properties = null;
    }

    private void parseExtensionAttributes(Attributes attributes) {
        Extension currentExtension = new Extension();
        this.objectStack.push(currentExtension);
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                currentExtension.setLabel(this.translate(attrValue));
            } else if (attrName.equals("id")) {
                currentExtension.setSimpleIdentifier(attrValue);
            } else if (attrName.equals(EXTENSION_TARGET)) {
                String targetName;
                if (attrValue.lastIndexOf(46) == -1) {
                    String baseId = this.namespace.getNamespace();
                    targetName = String.valueOf(baseId) + "." + attrValue;
                } else {
                    targetName = attrValue;
                }
                currentExtension.setExtensionPointIdentifier(targetName);
            } else {
                this.unknownAttribute(EXTENSION, attrName);
            }
            ++i;
        }
        if (currentExtension.getExtensionPointIdentifier() == null) {
            this.missingAttribute(EXTENSION_TARGET, EXTENSION);
            this.stateStack.pop();
            this.stateStack.push(new Integer(0));
            this.objectStack.pop();
            return;
        }
        this.objectManager.add(currentExtension, true);
    }

    private void missingAttribute(String attribute, String element) {
        if (this.locator == null) {
            this.internalError(NLS.bind((String)Messages.parse_missingAttribute, (Object)attribute, (Object)element));
        } else {
            this.internalError(NLS.bind((String)Messages.parse_missingAttributeLine, (Object[])new String[]{attribute, element, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void unknownAttribute(String attribute, String element) {
        if (this.locator == null) {
            this.internalError(NLS.bind((String)Messages.parse_unknownAttribute, (Object)attribute, (Object)element));
        } else {
            this.internalError(NLS.bind((String)Messages.parse_unknownAttributeLine, (Object[])new String[]{attribute, element, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void unknownElement(String element, String parent) {
        if (this.locator == null) {
            this.internalError(NLS.bind((String)Messages.parse_unknownElement, (Object)parent, (Object)element));
        } else {
            this.internalError(NLS.bind((String)Messages.parse_unknownElementLine, (Object[])new String[]{parent, element, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void parseExtensionPointAttributes(Attributes attributes) {
        ExtensionPoint currentExtPoint = new ExtensionPoint();
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                currentExtPoint.setLabel(this.translate(attrValue));
            } else if (attrName.equals("id")) {
                currentExtPoint.setUniqueIdentifier(String.valueOf(this.namespace.getNamespace()) + '.' + attrValue);
            } else if (attrName.equals(EXTENSION_POINT_SCHEMA)) {
                currentExtPoint.setSchema(attrValue);
            } else {
                this.unknownAttribute(EXTENSION_POINT, attrName);
            }
            ++i;
        }
        if (currentExtPoint.getSimpleIdentifier() == null || currentExtPoint.getLabel() == null) {
            String attribute = currentExtPoint.getSimpleIdentifier() == null ? "id" : "name";
            this.missingAttribute(attribute, EXTENSION_POINT);
            this.stateStack.pop();
            this.stateStack.push(new Integer(0));
            return;
        }
        this.objectManager.addExtensionPoint(currentExtPoint, true);
        currentExtPoint.setNamespace(this.namespace.getNamespace());
        currentExtPoint.setBundleId(this.namespace.getNamespaceBundle().getBundleId());
        this.scratchVectors[0].add(currentExtPoint);
    }

    public void startDocument() {
        this.stateStack.push(new Integer(1));
        int i = 0;
        while (i <= 1) {
            this.scratchVectors[i] = new ArrayList();
            ++i;
        }
    }

    public void startElement(String uri, String elementName, String qName, Attributes attributes) {
        switch ((Integer)this.stateStack.peek()) {
            case 1: {
                this.handleInitialState(elementName, attributes);
                break;
            }
            case 2: {
                this.handleBundleState(elementName, attributes);
                break;
            }
            case 5: {
                this.handleExtensionPointState(elementName);
                break;
            }
            case 6: 
            case 10: {
                this.handleExtensionState(elementName, attributes);
                break;
            }
            default: {
                this.stateStack.push(new Integer(0));
                if (this.compatibilityMode) break;
                this.internalError(NLS.bind((String)Messages.parse_unknownTopElement, (Object)elementName));
            }
        }
    }

    public void warning(SAXParseException ex) {
        this.logStatus(ex);
    }

    private void internalError(String message) {
        this.error(new Status(2, "org.eclipse.core.runtime", 1, message, null));
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equalsIgnoreCase("eclipse")) {
            this.schemaVersion = "3.0";
            StringTokenizer tokenizer = new StringTokenizer(data, "=\"");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equalsIgnoreCase("version")) continue;
                if (!tokenizer.hasMoreTokens()) break;
                this.schemaVersion = tokenizer.nextToken();
                break;
            }
        }
    }

    public void error(IStatus error) {
        this.status.add(error);
    }

    private String translate(String key) {
        return ResourceTranslator.getResourceString(null, key, this.resources);
    }

    private Extension[] fixRenamedExtensionPoints(Extension[] extensions) {
        if (extensions == null || this.schemaVersion != null && this.schemaVersion.equals("3.0") || System.getProperties().get(NO_EXTENSION_MUNGING) != null) {
            return extensions;
        }
        int i = 0;
        while (i < extensions.length) {
            Extension extension = extensions[i];
            String oldPointId = extension.getExtensionPointIdentifier();
            String newPointId = (String)extensionPointMap.get(oldPointId);
            if (newPointId != null) {
                extension.setExtensionPointIdentifier(newPointId);
            }
            ++i;
        }
        return extensions;
    }
}

