/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class VersionHashMap {
    private HashMap internal = new HashMap();

    Object put(VersionSupplier versionSupplier) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(versionSupplier.getName());
        if (existing == null) {
            VersionSupplier[] vss = new VersionSupplier[]{versionSupplier};
            this.internal.put(versionSupplier.getName(), vss);
        } else {
            int i = 0;
            while (i < existing.length) {
                VersionSupplier e = existing[i];
                if (e == versionSupplier) {
                    return e;
                }
                if (versionSupplier.getBundle().isResolved() && !e.getBundle().isResolved()) {
                    this.internal.put(versionSupplier.getName(), this.add(i, versionSupplier, existing));
                    return null;
                }
                if (versionSupplier.getBundle().isResolved() == e.getBundle().isResolved()) {
                    if (versionSupplier.getVersion().compareTo(e.getVersion()) > 0) {
                        this.internal.put(versionSupplier.getName(), this.add(i, versionSupplier, existing));
                        return null;
                    }
                    if (e.getVersion().equals(versionSupplier.getVersion()) && versionSupplier.getBundle().getBundleId() < e.getBundle().getBundleId()) {
                        this.internal.put(versionSupplier.getName(), this.add(i, versionSupplier, existing));
                        return e;
                    }
                }
                ++i;
            }
            this.internal.put(versionSupplier.getName(), this.add(existing.length, versionSupplier, existing));
        }
        return null;
    }

    void put(VersionSupplier[] versionSuppliers) {
        int i = 0;
        while (i < versionSuppliers.length) {
            this.put(versionSuppliers[i]);
            ++i;
        }
    }

    private VersionSupplier[] add(int index, VersionSupplier versionSupplier, VersionSupplier[] existing) {
        VersionSupplier[] newVS = new VersionSupplier[existing.length + 1];
        int i = 0;
        while (i < index) {
            newVS[i] = existing[i];
            ++i;
        }
        newVS[index] = versionSupplier;
        i = index + 1;
        while (i < newVS.length) {
            newVS[i] = existing[i - 1];
            ++i;
        }
        return newVS;
    }

    VersionSupplier[] getArray(String supplierName) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(supplierName);
        if (existing != null) {
            return existing;
        }
        return new VersionSupplier[0];
    }

    boolean contains(VersionSupplier vs) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(vs.getName());
        if (existing == null) {
            return false;
        }
        int i = 0;
        while (i < existing.length) {
            if (existing[i] == vs) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void remove(VersionSupplier[] existing, String name, int index) {
        if (existing.length == 1) {
            this.internal.remove(name);
        } else {
            VersionSupplier[] newVS = new VersionSupplier[existing.length - 1];
            int i = 0;
            while (i < index) {
                newVS[i] = existing[i];
                ++i;
            }
            i = index + 1;
            while (i < existing.length) {
                newVS[i - 1] = existing[i];
                ++i;
            }
            this.internal.put(name, newVS);
        }
    }

    Object remove(VersionSupplier toBeRemoved) {
        VersionSupplier[] existing = (VersionSupplier[])this.internal.get(toBeRemoved.getName());
        if (existing != null) {
            int i = 0;
            while (i < existing.length) {
                if (toBeRemoved == existing[i]) {
                    this.remove(existing, toBeRemoved.getName(), i);
                    return toBeRemoved;
                }
                ++i;
            }
        }
        return null;
    }

    void remove(VersionSupplier[] versionSuppliers) {
        int i = 0;
        while (i < versionSuppliers.length) {
            this.remove(versionSuppliers[i]);
            ++i;
        }
    }

    void reorder() {
        Iterator it = this.internal.values().iterator();
        while (it.hasNext()) {
            ArrayList<VersionSupplier> toBeReordered = new ArrayList<VersionSupplier>();
            VersionSupplier[] existing = (VersionSupplier[])it.next();
            if (existing == null || existing.length <= 1) continue;
            VersionSupplier vs1 = existing[0];
            int i = 1;
            while (i < existing.length) {
                int versionDiff;
                VersionSupplier vs2 = existing[i];
                BundleDescription b1 = vs1.getBundle();
                BundleDescription b2 = vs2.getBundle();
                if (b2.isResolved() && !b1.isResolved()) {
                    toBeReordered.add(vs2);
                } else if (b2.isResolved() == b1.isResolved() && ((versionDiff = vs2.getVersion().compareTo(vs1.getVersion())) > 0 || b2.getBundleId() < b1.getBundleId() && versionDiff == 0)) {
                    toBeReordered.add(vs2);
                }
                vs1 = vs2;
                ++i;
            }
            i = 0;
            while (i < toBeReordered.size()) {
                VersionSupplier vs = (VersionSupplier)toBeReordered.get(i);
                this.remove(vs);
                this.put(vs);
                ++i;
            }
        }
    }
}

