/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.FormInfo;
import tk.eclipse.plugin.struts.PropertyInfo;
import tk.eclipse.plugin.struts.Util;

public class StrutsProject {
    private IProject project;
    private IJavaProject javaProject;

    public StrutsProject(IProject project) {
        this.project = project;
        this.javaProject = JavaCore.create((IProject)project);
    }

    public IFile[] getStrutsConfigXML() {
        try {
            FuzzyXMLDocument doc;
            String value;
            HTMLProjectParams params = new HTMLProjectParams(this.project);
            IPath path = new Path(params.getRoot()).append("/WEB-INF/web.xml");
            IFile file = this.project.getFile(path);
            if (file != null && file.exists() && (value = HTMLUtil.getXPathValue((FuzzyXMLElement)(doc = new FuzzyXMLParser().parse(file.getContents())).getDocumentElement(), (String)"/web-app/servlet[servlet-name='action']/init-param[param-name='config']/param-value")) != null) {
                String[] names = value.split(",");
                ArrayList<IFile> files = new ArrayList<IFile>();
                int i = 0;
                while (i < names.length) {
                    path = new Path(params.getRoot()).append(names[i].trim());
                    file = this.project.getFile(path);
                    if (file != null && file.exists()) {
                        files.add(file);
                    }
                    ++i;
                }
                return files.toArray(new IFile[files.size()]);
            }
            path = new Path(params.getRoot()).append("/WEB-INF/struts-config.xml");
            file = this.project.getFile(path);
            if (file != null && file.exists()) {
                return new IFile[]{file};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new IFile[0];
    }

    public String getExtension() {
        try {
            FuzzyXMLDocument doc;
            String value;
            HTMLProjectParams params = new HTMLProjectParams(this.project);
            IPath path = new Path(params.getRoot()).append("/WEB-INF/web.xml");
            IFile file = this.project.getFile(path);
            if (file != null && file.exists() && (value = HTMLUtil.getXPathValue((FuzzyXMLElement)(doc = new FuzzyXMLParser().parse(file.getContents())).getDocumentElement(), (String)"/web-app/servlet-mapping[servlet-name='action']/url-pattern")) != null && value.startsWith("*.")) {
                return value.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "do";
    }

    public IFile[] getTilesXML() {
        ArrayList<IFile> tiles = new ArrayList<IFile>();
        try {
            HTMLProjectParams params = new HTMLProjectParams(this.project);
            IFile[] files = this.getStrutsConfigXML();
            int i = 0;
            while (i < files.length) {
                try {
                    FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
                    FuzzyXMLNode node = HTMLUtil.selectXPathNode((FuzzyXMLElement)doc.getDocumentElement(), (String)"/struts-config/plug-in[@className='org.apache.struts.tiles.TilesPlugin']/set-property[@property='definitions-config']");
                    if (node != null) {
                        String value = ((FuzzyXMLElement)node).getAttributeNode("value").getValue();
                        String[] dim = value.split(",");
                        int j = 0;
                        while (j < dim.length) {
                            IPath path = new Path(params.getRoot()).append(dim[j].trim());
                            IFile file = this.project.getFile(path);
                            if (file != null && file.exists()) {
                                tiles.add(file);
                            }
                            ++j;
                        }
                    }
                }
                catch (Exception ex) {
                    Util.logException(ex);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
        return tiles.toArray(new IFile[tiles.size()]);
    }

    public IFile[] getValidatorXML() {
        ArrayList<IFile> validators = new ArrayList<IFile>();
        try {
            HTMLProjectParams params = new HTMLProjectParams(this.project);
            IFile[] files = this.getStrutsConfigXML();
            int i = 0;
            while (i < files.length) {
                try {
                    FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
                    FuzzyXMLNode node = HTMLUtil.selectXPathNode((FuzzyXMLElement)doc.getDocumentElement(), (String)"/struts-config/plug-in[@className='org.apache.struts.validator.ValidatorPlugIn']/set-property[@property='pathnames']");
                    if (node != null) {
                        String value = ((FuzzyXMLElement)node).getAttributeNode("value").getValue();
                        String[] dim = value.split(",");
                        int j = 0;
                        while (j < dim.length) {
                            IPath path = new Path(params.getRoot()).append(dim[j].trim());
                            IFile file = this.project.getFile(path);
                            if (file != null && file.exists()) {
                                validators.add(file);
                            }
                            ++j;
                        }
                    }
                }
                catch (Exception ex) {
                    Util.logException(ex);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
        return validators.toArray(new IFile[validators.size()]);
    }

    public FormInfo[] getActionForms() {
        ArrayList<FormInfo> formInfos = new ArrayList<FormInfo>();
        IFile[] files = this.getStrutsConfigXML();
        int i = 0;
        while (i < files.length) {
            try {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
                FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"//struts-config/form-beans/form-bean");
                int j = 0;
                while (j < nodes.length) {
                    try {
                        FuzzyXMLElement element = (FuzzyXMLElement)nodes[j];
                        String formName = element.getAttributeNode("name").getValue();
                        String clazzName = element.getAttributeNode("type").getValue();
                        IType type = null;
                        try {
                            type = this.javaProject.findType(clazzName);
                        }
                        catch (JavaModelException javaModelException) {
                            // empty catch block
                        }
                        FuzzyXMLNode[] props = HTMLUtil.selectXPathNodes((FuzzyXMLElement)element, (String)"/form-property");
                        PropertyInfo[] dynaProperties = new PropertyInfo[props.length];
                        int k = 0;
                        while (k < props.length) {
                            dynaProperties[k] = new PropertyInfo(((FuzzyXMLElement)props[k]).getAttributeNode("name").getValue(), ((FuzzyXMLElement)props[k]).getAttributeNode("type").getValue());
                            ++k;
                        }
                        if (type != null) {
                            formInfos.add(new FormInfo(formName, type, dynaProperties));
                        } else {
                            formInfos.add(new FormInfo(formName, null, dynaProperties));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
            ++i;
        }
        return formInfos.toArray(new FormInfo[formInfos.size()]);
    }

    public boolean existsClass(String className) {
        try {
            IType type = this.javaProject.findType(className);
            if (type.isClass() && type.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String[] getTilesDefinition() {
        IFile[] files = this.getTilesXML();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < files.length) {
            try {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(files[i].getContents());
                FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/tiles-definitions/definition");
                int j = 0;
                while (j < nodes.length) {
                    FuzzyXMLElement element = (FuzzyXMLElement)nodes[j];
                    FuzzyXMLAttribute attr = element.getAttributeNode("name");
                    if (attr != null) {
                        list.add(attr.getValue());
                    }
                    ++j;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean existsJSP(String path) {
        try {
            IFile jsp;
            HTMLProjectParams params = new HTMLProjectParams(this.project);
            if (path.indexOf("?") > 0) {
                path = path.substring(0, path.indexOf("?"));
            }
            if ((jsp = this.project.getFile(new Path(params.getRoot()).append(path))) != null && jsp.exists()) {
                return true;
            }
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
        return false;
    }
}

