/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import tk.eclipse.plugin.struts.editors.models.TilesAttributeModel;
import tk.eclipse.plugin.struts.editors.models.TilesDefinitionModel;
import tk.eclipse.plugin.struts.editors.models.TilesRootModel;

public class TilesDefsSAXHandler
extends DefaultHandler
implements LexicalHandler {
    private TilesRootModel root = new TilesRootModel();
    private Stack stack = new Stack();

    private Object getPrevObject() {
        if (this.stack.size() == 0) {
            return null;
        }
        return this.stack.get(this.stack.size() - 1);
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("definition")) {
            this.handleDefinition(attributes);
        } else if (qName.equals("put")) {
            this.handlePut(attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("definition")) {
            this.handleDefinition(null);
        } else if (qName.equals("put")) {
            this.handlePut(null);
        }
    }

    private void handleDefinition(Attributes attributes) {
        TilesDefinitionModel model;
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        String name = attributes.getValue("name");
        String path = attributes.getValue("path");
        if (path == null) {
            path = attributes.getValue("page");
        }
        if (path == null) {
            path = attributes.getValue("template");
        }
        String extendedDefinitionName = attributes.getValue("extends");
        TilesDefinitionModel extendedDefinition = null;
        if (extendedDefinitionName != null && (extendedDefinition = this.root.getDefinition(extendedDefinitionName)) == null) {
            extendedDefinition = new TilesDefinitionModel();
            extendedDefinition.setName(extendedDefinitionName);
            this.root.addDefinition(extendedDefinition);
        }
        if ((model = this.root.getDefinition(name)) == null) {
            model = new TilesDefinitionModel();
            model.setName(name);
            this.root.addDefinition(model);
        }
        model.setPath(path);
        model.setExtendedDefinition(extendedDefinition);
        this.stack.push(model);
    }

    private void handlePut(Attributes attributes) {
        String type;
        if (attributes == null) {
            this.stack.pop();
            return;
        }
        String name = attributes.getValue("name");
        String value = attributes.getValue("value");
        if (value == null) {
            value = attributes.getValue("content");
        }
        if ((type = attributes.getValue("type")) == null && Boolean.valueOf(attributes.getValue("direct")).booleanValue()) {
            type = "string";
        }
        TilesAttributeModel model = new TilesAttributeModel();
        model.setName(name);
        model.setValue(value);
        model.setType(type);
        TilesDefinitionModel definition = (TilesDefinitionModel)this.getPrevObject();
        definition.addAttribute(model);
        this.stack.push(model);
    }

    public TilesRootModel getModel() {
        return this.root;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }
}

