;; Japanese EUC
(define ja-rk-rule
  '(
    ((("-"). ())("".""))
    (((","). ())("".""))
    ((("."). ())("".""))
    ((("!"). ())("".""))
    ((("\""). ())("".""))
    ((("#"). ())("".""))
    ((("$"). ())("".""))
    ((("%"). ())("".""))
    ((("&"). ())("".""))
    ((("'"). ())("".""))
    ((("("). ())("".""))
    (((")"). ())("".""))
    ((("~"). ())("".""))
    ((("="). ())("".""))
    ((("^"). ())("".""))
    ((("\\"). ())("".""))
    ((("|"). ())("".""))
    ((("`"). ())("".""))
    ((("@"). ())("".""))
    ((("{"). ())("".""))
    ((("["). ())("".""))
    ((("+"). ())("".""))
    (((";"). ())("".""))
    ((("*"). ())("".""))
    (((":"). ())("".""))
    ((("}"). ())("".""))
    ((("]"). ())("".""))
    ((("<"). ())("".""))
    (((">"). ())("".""))
    ((("?"). ())("".""))
    ((("/"). ())("".""))
    ((("_"). ())("".""))

    ((("1"). ())("1"."1"))
    ((("2"). ())("2"."2"))
    ((("3"). ())("3"."3"))
    ((("4"). ())("4"."4"))
    ((("5"). ())("5"."5"))
    ((("6"). ())("6"."6"))
    ((("7"). ())("7"."7"))
    ((("8"). ())("8"."8"))
    ((("9"). ())("9"."9"))
    ((("0"). ())("0"."0"))

    ((("a"). ())("".""))
    ((("i"). ())("".""))
    ((("u"). ())("".""))
    ((("e"). ())("".""))
    ((("o"). ())("".""))

    ((("x" "a"). ())("".""))
    ((("x" "i"). ())("".""))
    ((("x" "u"). ())("".""))
    ((("x" "e"). ())("".""))
    ((("x" "o"). ())("".""))

    ((("k" "k"). ("k"))("".""))
    ((("k" "a"). ())("".""))
    ((("k" "i"). ())("".""))
    ((("k" "u"). ())("".""))
    ((("k" "e"). ())("".""))
    ((("k" "o"). ())("".""))

    ((("k" "y" "a"). ())("".""))
    ((("k" "y" "i"). ())("".""))
    ((("k" "y" "u"). ())("".""))
    ((("k" "y" "e"). ())("".""))
    ((("k" "y" "o"). ())("".""))

    ((("g" "g"). ("g"))("".""))
    ((("g" "a"). ())("".""))
    ((("g" "i"). ())("".""))
    ((("g" "u"). ())("".""))
    ((("g" "e"). ())("".""))
    ((("g" "o"). ())("".""))

    ((("g" "y" "a"). ())("".""))
    ((("g" "y" "i"). ())("".""))
    ((("g" "y" "u"). ())("".""))
    ((("g" "y" "e"). ())("".""))
    ((("g" "y" "o"). ())("".""))

    ((("s" "s"). ("s"))("".""))
    ((("s" "a"). ())("".""))
    ((("s" "i"). ())("".""))
    ((("s" "u"). ())("".""))
    ((("s" "e"). ())("".""))
    ((("s" "o"). ())("".""))

    ((("s" "y" "a"). ())("".""))
    ((("s" "y" "i"). ())("".""))
    ((("s" "y" "u"). ())("".""))
    ((("s" "y" "e"). ())("".""))
    ((("s" "y" "o"). ())("".""))

    ((("s" "h" "a"). ())("".""))
    ((("s" "h" "i"). ())("".""))
    ((("s" "h" "u"). ())("".""))
    ((("s" "h" "e"). ())("".""))
    ((("s" "h" "o"). ())("".""))

    ((("z" "z"). ("z"))("".""))
    ((("z" "a"). ())("".""))
    ((("z" "i"). ())("".""))
    ((("z" "u"). ())("".""))
    ((("z" "e"). ())("".""))
    ((("z" "o"). ())("".""))

    ((("z" "y" "a"). ())("".""))
    ((("z" "y" "i"). ())("".""))
    ((("z" "y" "u"). ())("".""))
    ((("z" "y" "e"). ())("".""))
    ((("z" "y" "o"). ())("".""))

    ((("j" "j"). ("j"))("".""))

    ((("j" "a"). ())("".""))
    ((("j" "i"). ())("".""))
    ((("j" "u"). ())("".""))
    ((("j" "e"). ())("".""))
    ((("j" "o"). ())("".""))

    ((("j" "y" "a"). ())("".""))
    ((("j" "y" "i"). ())("".""))
    ((("j" "y" "u"). ())("".""))
    ((("j" "y" "e"). ())("".""))
    ((("j" "y" "o"). ())("".""))

    ((("t" "t"). ("t"))("".""))
    ((("t" "c"). ("c"))("".""))

    ((("t" "a"). ())("".""))
    ((("t" "i"). ())("".""))
    ((("t" "u"). ())("".""))
    ((("t" "e"). ())("".""))
    ((("t" "o"). ())("".""))

    ((("t" "y" "a"). ())("".""))
    ((("t" "y" "i"). ())("".""))
    ((("t" "y" "u"). ())("".""))
    ((("t" "y" "e"). ())("".""))
    ((("t" "y" "o"). ())("".""))

    ((("t" "w" "u"). ())("Ȥ"."ȥ"))

    ((("t" "h" "a"). ())("Ƥ"."ƥ"))
    ((("t" "h" "i"). ())("Ƥ"."ƥ"))
    ((("t" "h" "u"). ())("Ƥ"."ƥ"))
    ((("t" "h" "e"). ())("Ƥ"."ƥ"))
    ((("t" "h" "o"). ())("Ƥ"."ƥ"))

    ((("c" "h" "a"). ())("".""))
    ((("c" "h" "i"). ())("".""))
    ((("c" "h" "u"). ())("".""))
    ((("c" "h" "e"). ())("".""))
    ((("c" "h" "o"). ())("".""))

    ((("t" "s" "u"). ())("".""))
    ((("x" "t" "u"). ())("".""))
    ((("x" "t" "s" "u"). ())("".""))
    ((("c"). ("c"))("".""))

    ((("d"). ("d"))("".""))

    ((("d" "a"). ())("".""))
    ((("d" "i"). ())("".""))
    ((("d" "u"). ())("".""))
    ((("d" "e"). ())("".""))
    ((("d" "o"). ())("".""))

    ((("d" "y" "a"). ())("¤"."¥"))
    ((("d" "y" "i"). ())("¤"."¥"))
    ((("d" "y" "u"). ())("¤"."¥"))
    ((("d" "y" "e"). ())("¤"."¥"))
    ((("d" "y" "o"). ())("¤"."¥"))

    ((("d" "h" "a"). ())("Ǥ"."ǥ"))
    ((("d" "h" "i"). ())("Ǥ"."ǥ"))
    ((("d" "h" "u"). ())("Ǥ"."ǥ"))
    ((("d" "h" "e"). ())("Ǥ"."ǥ"))
    ((("d" "h" "o"). ())("Ǥ"."ǥ"))

    ((("n" "n"). ())("".""))
    ((("n"). ())("".""))
    ((("n" "n"). ())("".""))

    ((("n" "a"). ())("".""))
    ((("n" "i"). ())("".""))
    ((("n" "u"). ())("".""))
    ((("n" "e"). ())("".""))
    ((("n" "o"). ())("".""))

    ((("n" "y" "a"). ())("ˤ"."˥"))
    ((("n" "y" "i"). ())("ˤ"."˥"))
    ((("n" "y" "u"). ())("ˤ"."˥"))
    ((("n" "y" "e"). ())("ˤ"."˥"))
    ((("n" "y" "o"). ())("ˤ"."˥"))

    ((("h" "h"). ("h"))("".""))

    ((("h" "a"). ())("".""))
    ((("h" "i"). ())("".""))
    ((("h" "u"). ())("".""))
    ((("h" "e"). ())("".""))
    ((("h" "o"). ())("".""))

    ((("h" "y" "a"). ())("Ҥ"."ҥ"))
    ((("h" "y" "i"). ())("Ҥ"."ҥ"))
    ((("h" "y" "u"). ())("Ҥ"."ҥ"))
    ((("h" "y" "e"). ())("Ҥ"."ҥ"))
    ((("h" "y" "o"). ())("Ҥ"."ҥ"))

    ((("f" "f"). ("f"))("".""))

    ((("f" "a"). ())("դ"."ե"))
    ((("f" "i"). ())("դ"."ե"))
    ((("f" "u"). ())("".""))
    ((("f" "e"). ())("դ"."ե"))
    ((("f" "o"). ())("դ"."ե"))

    ((("f" "y" "a"). ())("դ"."ե"))
    ((("f" "y" "i"). ())("դ"."ե"))
    ((("f" "y" "u"). ())("դ"."ե"))
    ((("f" "y" "e"). ())("դ"."ե"))
    ((("f" "y" "o"). ())("դ"."ե"))

    ((("b" "b"). ("b"))("".""))

    ((("b" "a"). ())("".""))
    ((("b" "i"). ())("".""))
    ((("b" "u"). ())("".""))
    ((("b" "e"). ())("".""))
    ((("b" "o"). ())("".""))

    ((("b" "y" "a"). ())("Ӥ"."ӥ"))
    ((("b" "y" "i"). ())("Ӥ"."ӥ"))
    ((("b" "y" "u"). ())("Ӥ"."ӥ"))
    ((("b" "y" "e"). ())("Ӥ"."ӥ"))
    ((("b" "y" "o"). ())("Ӥ"."ӥ"))

    ((("p" "p"). ("p"))("".""))

    ((("p" "a"). ())("".""))
    ((("p" "i"). ())("".""))
    ((("p" "u"). ())("".""))
    ((("p" "e"). ())("".""))
    ((("p" "o"). ())("".""))

    ((("p" "y" "a"). ())("Ԥ"."ԥ"))
    ((("p" "y" "i"). ())("Ԥ"."ԥ"))
    ((("p" "y" "u"). ())("Ԥ"."ԥ"))
    ((("p" "y" "e"). ())("Ԥ"."ԥ"))
    ((("p" "y" "o"). ())("Ԥ"."ԥ"))

    ((("m" "m"). ())("".""))
    ((("m" "b"). ("b"))("".""))
    ((("m" "p"). ("p"))("".""))

    ((("m" "a"). ())("".""))
    ((("m" "i"). ())("".""))
    ((("m" "u"). ())("".""))
    ((("m" "e"). ())("".""))
    ((("m" "o"). ())("".""))

    ((("m" "y" "a"). ())("ߤ"."ߥ"))
    ((("m" "y" "i"). ())("ߤ"."ߥ"))
    ((("m" "y" "u"). ())("ߤ"."ߥ"))
    ((("m" "y" "e"). ())("ߤ"."ߥ"))
    ((("m" "y" "o"). ())("ߤ"."ߥ"))

    ((("y" "a"). ())("".""))
    ((("y" "u"). ())("".""))
    ((("y" "o"). ())("".""))

    ((("x" "y" "a"). ())("".""))
    ((("x" "y" "u"). ())("".""))
    ((("x" "y" "o"). ())("".""))

    ((("r" "r"). ("r"))("".""))

    ((("r" "a"). ())("".""))
    ((("r" "i"). ())("".""))
    ((("r" "u"). ())("".""))
    ((("r" "e"). ())("".""))
    ((("r" "o"). ())("".""))

    ((("r" "y" "a"). ())("".""))
    ((("r" "y" "i"). ())("ꤣ"."ꥣ"))
    ((("r" "y" "u"). ())("".""))
    ((("r" "y" "e"). ())("ꤧ"."ꥧ"))
    ((("r" "y" "o"). ())("".""))

    ((("w" "w"). ("w"))("".""))
    ((("x" "w" "a"). ())("".""))
    ((("w" "a"). ())("".""))
    ((("w" "i"). ())("".""))
    ((("x" "w" "i"). ())("".""))
    ((("w" "u"). ())("".""))
    ((("w" "e"). ())("".""))
    ((("x" "w" "e"). ())("".""))
    ((("w" "o"). ())("".""))

    ((("v" "v"). ("v"))("".""))
    ((("v" "a"). ())("".""))
    ((("v" "i"). ())("".""))
    ((("v" "u"). ())("".""))
    ((("v" "e"). ())("".""))
    ((("v" "o"). ())("".""))


    ((("z" "k"). ())("".""))
    ((("z" "j"). ())("".""))
    ((("z" "h"). ())("".""))
    ((("z" "l"). ())("".""))
    ((("z" "-"). ())("".""))
    ((("z" "["). ())("".""))
    ((("z" "]"). ())("".""))
    ((("z" ","). ())("".""))
    ((("z" "."). ())("".""))
    ((("z" "/"). ())("".""))
    ))

(define ja-wide-rule
  '(("a" "")
    ("b" "")
    ("c" "")
    ("d" "")
    ("e" "")
    ("f" "")
    ("g" "")
    ("h" "")
    ("i" "")
    ("j" "")
    ("k" "")
    ("l" "")
    ("m" "")
    ("n" "")
    ("o" "")
    ("p" "")
    ("q" "")
    ("r" "")
    ("s" "")
    ("t" "")
    ("u" "")
    ("v" "")
    ("w" "")
    ("x" "")
    ("y" "")
    ("z" "")
    ("A" "")
    ("B" "")
    ("C" "")
    ("D" "")
    ("E" "")
    ("F" "")
    ("G" "")
    ("H" "")
    ("I" "")
    ("J" "")
    ("K" "")
    ("L" "")
    ("M" "")
    ("N" "")
    ("O" "")
    ("P" "")
    ("Q" "")
    ("R" "")
    ("S" "")
    ("T" "")
    ("U" "")
    ("V" "")
    ("W" "")
    ("X" "")
    ("Y" "")
    ("Z" "")

    ("1" "")
    ("2" "")
    ("3" "")
    ("4" "")
    ("5" "")
    ("6" "")
    ("7" "")
    ("8" "")
    ("9" "")
    ("0" "")

    ("-" "")
    ("," "")
    ("." "")
    ("!" "")
    ("\"" "")
    ("#" "")
    ("$" "")
    ("%" "")
    ("&" "")
    ("'" "")
    ("(" "")
    (")" "")
    ("~" "")
    ("=" "")
    ("^" "")
    ("\\" "")
    ("|" "")
    ("`" "")
    ("@" "")
    ("{" "")
    ("[" "")
    ("+" "")
    (";" "")
    ("*" "")
    (":" "")
    ("}" "")
    ("]" "")
    ("<" "")
    (">" "")
    ("?" "")
    ("/" "")
    ("_"  "")
    ))

(define ja-kana-rule
  '(
    ((("1"). ()) ("".""))
    ((("2"). ()) ("".""))
    ((("3"). ()) ("".""))
    ((("4"). ())("".""))
    ((("5"). ())("".""))
    ((("6"). ())("".""))
    ((("7"). ())("".""))
    ((("8"). ())("".""))
    ((("9"). ())("".""))
    ((("0"). ())("".""))
    ((("-"). ())("".""))
    ((("^"). ())("".""))
    ((("|"). ())("".""))
    ((("q"). ())("".""))
    ((("w"). ())("".""))
    ((("e"). ())("".""))
    ((("r"). ())("".""))
    ((("t"). ())("".""))
    ((("y"). ())("".""))
    ((("u"). ())("".""))
    ((("i"). ())("".""))
    ((("o"). ())("".""))
    ((("p"). ())("".""))
    ((("@"). ())("".""))
    ((("["). ())("".""))
    ((("a"). ())("".""))
    ((("s"). ())("".""))
    ((("d"). ())("".""))
    ((("f"). ())("".""))
    ((("g"). ())("".""))
    ((("h"). ())("".""))
    ((("j"). ())("".""))
    ((("k"). ())("".""))
    ((("l"). ())("".""))
    (((";"). ())("".""))
    (((":"). ())("".""))
    ((("]"). ())("".""))
    ((("z"). ())("".""))
    ((("x"). ())("".""))
    ((("c"). ())("".""))
    ((("v"). ())("".""))
    ((("b"). ())("".""))
    ((("n"). ())("".""))
    ((("m"). ())("".""))
    (((","). ())("".""))
    ((("."). ())("".""))
    ((("/"). ())("".""))
    ((("\\"). ())("".""))
    ((("#"). ())("".""))
    ((("$"). ())("".""))
    ((("%"). ())("".""))
    ((("&"). ())("".""))
    ((("'"). ())("".""))
    ((("("). ())("".""))
    (((")"). ())("".""))
    ((("~"). ())("".""))
    ((("{"). ())("".""))
    ((("}"). ())("".""))
    ((("P"). ())("".""))
    ((("+"). ())("".""))
    ((("?"). ())("".""))
    (((">"). ())("".""))
    ((("<"). ())("".""))
    ((("E"). ())("".""))
    ((("Z"). ())("".""))
    ((("t" "@"). ())("".""))
    ((("g" "@"). ())("".""))
    ((("h" "@"). ())("".""))
    (((":" "@"). ())("".""))
    ((("b" "@"). ())("".""))
    ((("x" "@"). ())("".""))
    ((("d" "@"). ())("".""))
    ((("r" "@"). ())("".""))
    ((("p" "@"). ())("".""))
    ((("c" "@"). ())("".""))
    ((("q" "@"). ())("".""))
    ((("a" "@"). ())("".""))
    ((("z" "@"). ())("".""))
    ((("w" "@"). ())("".""))
    ((("s" "@"). ())("".""))
    ((("f" "@"). ())("".""))
    ((("v" "@"). ())("".""))
    ((("2" "@"). ())("".""))
    ((("^" "@"). ())("".""))
    ((("-" "@"). ())("".""))
    ((("f" "["). ())("".""))
    ((("v" "["). ())("".""))
    ((("2" "["). ())("".""))
    ((("^" "["). ())("".""))
    ((("-" "["). ())("".""))
    ))

;(define ja-rk-rule ja-kana-rule)

(define ja-direct-rule
  '((" " "")
    ))
;;
(define ja-find-rec
  (lambda (c rule)
    (if (null? rule)
	nil
	(let ((r (car rule)))
	  (if (string-equal? c (car r))
	      (cadr r)
	      (ja-find-rec c (cdr rule)))))))

(define ja-wide
  (lambda (c)
    (ja-find-rec c ja-wide-rule)))

(define ja-direct
  (lambda (c)
    (ja-find-rec c ja-direct-rule)))
;;
(require "rk.scm")
