// -*- C++ -*-
#ifndef _imconn_h_included_
#define _imconn_h_included_

#include <list>
#include <map>

class RxPacket;
class TxPacket;

class IMIC;

class IMConn{
public:
  IMConn(int fd);
  ~IMConn();
  int getFd();
  bool isWritePending();
  bool isValid();
  void read_proc();
  void write_proc();

  void pushTxPacket(TxPacket *);
private:
  int mFd,endian;
  std::map<int,IMIC *> mICs;
  std::list<TxPacket *> mTxQ;


  void proc_initial_packet();
  void proc_packet();
  void dispatch_packet(RxPacket *);

  void proc_im_connect(RxPacket *);
  void proc_im_disconnect(RxPacket *);

  void proc_im_set_im_values(RxPacket *);

  void proc_im_create_ic(RxPacket *);
  void proc_im_destroy_ic(RxPacket *);
  void proc_im_reset_ic(RxPacket *);

  void proc_im_trigger_notify(RxPacket *);

  void proc_im_forward_event(RxPacket *);

  void proc_preedit_start_reply(RxPacket *);
  void proc_preedit_draw_reply(RxPacket *);
  void proc_preedit_done_reply(RxPacket *);

  void proc_status_start_reply(RxPacket *);
  void proc_status_draw_reply(RxPacket *);
  void proc_status_done_reply(RxPacket *);

  int get_unused_ic_id();
  IMIC *get_ic_by_id(int );
  enum {
    PRE_CONNECT,
    OK,
    CLOSE_WAIT,
    INVALID,
  }mStat;
};

extern int iiim_trace_flag,trace_flag;

#endif
