// IIIMP ΥѥåȤ
#include <stdio.h>
#include <ctype.h>
#include <list>
#include "packet.h"

//ۥȥѴ롣
static C16 readC16(unsigned char *val,int byte_order);
static C32 readC32(unsigned char *val,int byte_order);
static C64 readC64(unsigned char *val,int byte_order);

int pad4(int x)
{
    return (4-(x%4))%4;
}

int getSTRINGlen(STRING *s)
{
    int l;
    l = s->size();
    return l*2+pad4(2+l*2);
}

void hex_dump(unsigned char *buf,int len)
{
    int i,j;
    unsigned char c[16];
    for ( i = 0 ; i < len ; i += 16 ){
	printf("%8.8x ",i);
	for ( j = 0 ; j < 16 ; j++){
	    if ( i +j<len ){
		c[j]= buf[i+j];
		if ( j == 7){
		    printf("%2.2x-",c[j]);
		}else{
		    printf("%2.2x ",c[j]);
		}
	    }else{
		c[j]=0;
		printf("-- ");
	    }
	}
	printf(" ");
	for ( j = 0 ; j < 16 ; j++){
	    if ( isprint(c[j] )){
		printf("%c",c[j]);
	    }else{
		printf(".");
	    }
	}
	printf("\n");
    }
}

int rup4(int l)
{
    if ((l%4)==0){
        return l;
    }
    return (l&0xffffffc)+4;
}

void writeC8(C8 val,int byte_order,unsigned char *buf)
{
    buf[0] = val;
}

void writeC16(C16 val,int byte_order,unsigned char *buf)
{
    if ( byte_order == LSB_FIRST ){
        buf[0] = val & 255;
        buf[1] = (val >> 8) & 255;
    }else{
        buf[1] = val & 255;
        buf[0] = (val >> 8) & 255;
    }
}

void writeC32(unsigned int val,int byte_order,unsigned char *buf)
{
    if ( byte_order == LSB_FIRST ){
        buf[0] = val & 255;
        buf[1] = (val >> 8) & 255;
        buf[2] = (val >> 16) & 255;
        buf[3] = (val >> 24) & 255;
    }else{
        buf[3] = val & 255;
        buf[2] = (val >> 8) & 255;
        buf[1] = (val >> 16) & 255;
        buf[0] = (val >> 24) & 255;
    }
}

void writeC64(unsigned int val,int byte_order,unsigned char *buf)
{
    int i;
    for ( i = 0 ; i < 8 ; i++){
	if ( byte_order == LSB_FIRST ){
	    buf[i] = (val >> (8 * i)) & 255;
	}else{
	    buf[7-i] = (val >> (8 * i)) & 255;
	}
    }
}

C8 readC8(unsigned char *buf)
{
    return buf[0];
}

C16 readC16(unsigned char *buf,int byte_order)
{
    C16 v;
    if ( byte_order == LSB_FIRST ){
        v = buf[0] + buf[1]*256;
    }else{
        v = buf[1] + buf[0]*256;
    }
    return v;
}

C32 readC32(unsigned char *buf,int byte_order)
{
    C32 v;
    if ( byte_order == LSB_FIRST ){
        v = buf[0] + buf[1]*256 + (buf[2]<<16) +(buf[3]<<24);
    }else{
        v = buf[3] + buf[2]*256 + (buf[1]<<16) +(buf[0]<<24);
    }
    return v;
}

C64 readC64(unsigned char *buf,int byte_order)
{
    C64 v= 0;
    int i;
    for ( i = 0 ; i < 8 ; i++){
	v<<= 8;
	if ( byte_order == LSB_FIRST ){
	    v+= buf[i];
	}else{
	    v+= buf[7-i];
	}
    }
    return v;
}

//
// TxPacket
//

class TxElement{
public:
    virtual ~TxElement(){};
    virtual int get_size()=0;
    virtual int write_to_buf(unsigned char *buf,int byte_order)=0;
};

class TxC8 : public TxElement{
public:
    TxC8(int v){
        val = v;
    }
    int get_size()
    {
        return 1;
    }
    int write_to_buf(unsigned char *buf,int bo)
    {
        writeC8(val,bo,buf);
        return 1;
    }
private:
    C8 val;
};

class TxC16 : public TxElement{
public:
    TxC16(int v){
        val = v;
    }
    int get_size()
    {
        return 2;
    }
    int write_to_buf(unsigned char *buf,int bo)
    {
        writeC16(val,bo,buf);
        return 2;
    }
private:
    C16 val;
};

class TxC32 : public TxElement{
public:
    TxC32(unsigned int v){
        val = v;
    }
    int get_size()
    {
        return 4;
    }
    int write_to_buf(unsigned char *buf,int bo)
    {
        writeC32(val,bo,buf);
        return 4;
    }
private:
    C32 val;
};

class TxC64 : public TxElement{
public:
    TxC64(unsigned int v){
        val = v;
    }
    int get_size()
    {
        return 8;
    }
    int write_to_buf(unsigned char *buf,int bo)
    {
        writeC64(val,bo,buf);
        return 8;
    }
private:
    C64 val;
};

class TxSTRING : public TxElement{
public:
    TxSTRING(STRING str){
	mVal = str;
    }
    int get_size(){
	int len = mVal.size();
        return 2+2*len+pad4(2+2*len);
    }
    int write_to_buf(unsigned char *buf,int bo){
	STRING::iterator it;
        writeC16(mVal.size()*2,bo,buf);
	buf++,buf++;
	for ( it = mVal.begin() ; it != mVal.end() ; it ++ ){
	    writeC16(*it,bo,buf);
	    buf++,buf++;
	}
        return get_size();
    }
private:
    STRING mVal;
};

class TxBytes : public TxElement{
public:
    TxBytes(char *s,int len)
    {
        m_str = (char *)malloc(len);
        m_len = len;
        memcpy(m_str,s,len);
    };
    ~TxBytes()
    {
        free(m_str);
    }
    int get_size()
    {
        return m_len;
    }
    int write_to_buf(unsigned char *buf,int bo){
        memcpy(buf,m_str,m_len);
        return get_size();
    }
private:
    int m_len;
    char *m_str;
};

class TxPacket_impl : public TxPacket{
public:
    TxPacket_impl(int opcode);
    ~TxPacket_impl();

    int get_length();
    int write_to_buf(unsigned char *buf,int buflen,int byte_order);

    void dump(int byte_order);
    int getOpCode();

    int pushC8(unsigned int);
    int pushC16(unsigned int );
    int pushC32(unsigned int );
    int pushC64(unsigned long long );
    int pushSTRING(STRING );
    int pushBytes(char *,int );

    int pop_back();
private:
    void write_header(unsigned char *buf,int l,int byte_order);
    int mOpCode;
    std::list <TxElement *> m_elms;
};

TxPacket_impl::TxPacket_impl(int opcode)
{
    mOpCode = opcode;
}

TxPacket_impl::~TxPacket_impl()
{
    std::list<TxElement *>::iterator i;
    for ( i = m_elms.begin() ; i != m_elms.end() ; i++){
        delete *i;
    }
}

int TxPacket_impl::get_length()
{
    std::list<TxElement *>::iterator i;
    int l;
    l = 4;
    for ( i = m_elms.begin() ; i != m_elms.end() ; i++){
        l +=  (*i)->get_size();
    }  
    return l;
}

int TxPacket_impl::write_to_buf(unsigned char *buf,int buflen,int byte_order)
{
    std::list<TxElement *>::iterator i;
    int l,m;
    l = 4;
    for ( i = m_elms.begin() ; i != m_elms.end() ; i++){
        m = (*i)->get_size();
        if ( l + m > buflen ){
            return 0;
        }
        m = (*i)->write_to_buf(&buf[l],byte_order);
        l +=m;
    }
    l = rup4(l);
    write_header(buf,l,byte_order);
    return l;
}

int TxPacket_impl::pushC8(unsigned int v)
{
    TxElement *e;
    e = new TxC8(v);
    m_elms.push_back(e);
    return e->get_size();
}

int TxPacket_impl::pushC16(unsigned int v)
{
    TxElement *e;
    e = new TxC16(v);
    m_elms.push_back(e);
    return e->get_size();
}

int TxPacket_impl::pushC32(unsigned int v)
{
    TxElement *e;
    e = new TxC32(v);
    m_elms.push_back(e);
    return e->get_size();
}

int TxPacket_impl::pushSTRING(STRING s)
{
    TxElement *e;
    e = new TxSTRING(s);
    m_elms.push_back(e);
    return e->get_size();
}

int TxPacket_impl::pushBytes(char *b,int len)
{
    TxElement *e;
    e = new TxBytes(b,len);
    m_elms.push_back(e);
    return e->get_size();
}

int TxPacket_impl::pop_back()
{
    int len;
    TxElement *e;
    e = m_elms.back();
    len = e->get_size();
    delete e;
    m_elms.pop_back();
    return len;
}

void TxPacket_impl::write_header(unsigned char *buf,int l,int byte_order)
{
    l = l/4 -1;
    buf[0] = mOpCode;
    // MSB first
    buf[1] = (l>>16) & 255;
    buf[2] = (l>>8) & 255;
    buf[3] = l & 255;
}

void TxPacket_impl::dump(int byte_order)
{
    unsigned char *buf;
    int len;
    len = get_length();
    buf = (unsigned char *)malloc(len);
    write_to_buf(buf,len,byte_order);
    printf("TxPacket OPCODE=%d.\n",getOpCode());
    hex_dump(buf,len);
    free(buf);
}

int TxPacket_impl::getOpCode()
{
    return mOpCode;
}

TxPacket *createTxPacket(int opcode)
{
    return new TxPacket_impl(opcode);
}
//
// Routines for RxPacket
//

class RxPacket_impl : public RxPacket{
public:
    RxPacket_impl(void *buf,int len,int byte_order);

    void rewind();
    C8 getC8();
    C16 getC16();
    C32 getC32();
    STRING getSTRING();

    int getOpCode();
    bool isOverRun();

    void dump();
private:
    bool canRead(int );
    int m_len;
    unsigned char *m_buf;
    int m_index;
    int m_byteorder;
    bool mIsOverRun;
};

RxPacket_impl::RxPacket_impl(void *b,int len,int byte_order)
{
    m_len = len;
    m_buf = (unsigned char *)b;
    m_byteorder = byte_order;
    rewind();
}

void RxPacket_impl::rewind()
{
    if ( m_buf[0] & 0x80 ){
	m_index = 9;
    }else{
	m_index = 4;
    }
    mIsOverRun = false;
}

C8 RxPacket_impl::getC8()
{
    C8 v;
    if ( !canRead(1)){
	mIsOverRun = true;
	return 0;
    }
    v = readC8(&m_buf[m_index]);
    m_index += 1;
    return v;
}

C16 RxPacket_impl::getC16()
{
    C16 v;
    if ( !canRead(2)){
	mIsOverRun = true;
	return 0;
    }
    v = readC16(&m_buf[m_index], m_byteorder);
    m_index += 2;
    return v;
}

C32 RxPacket_impl::getC32()
{
    C32 v;
    if ( !canRead(4)){
	mIsOverRun = true;
	return 0;
    }
    v = readC32(&m_buf[m_index], m_byteorder);
    m_index += 4;
    return v;
}

STRING RxPacket_impl::getSTRING()
{
    STRING str;
    if ( !canRead(2)){
	mIsOverRun = true;
	return str;
    }
    C16 len = getC16();
    int i;
    if ( !canRead(len*2)){
	mIsOverRun = true;
	return str;
    }
    for ( i = 0 ; i < len ; i++){
	str.push_back(getC16());
    }
    return str;
}

int RxPacket_impl::getOpCode()
{
    return m_buf[0]&0x7f;
}

bool RxPacket_impl::isOverRun()
{
    return mIsOverRun;
}

void RxPacket_impl::dump()
{
    printf("RxPacket OPCODE=%d.\n",getOpCode());
    hex_dump(m_buf,m_len);
}

bool RxPacket_impl::canRead(int b)
{
    if ( m_len < m_index +b ){
	return false;
    }
    return true;
}

// static methods
int RxPacket::get_len(unsigned char *buf,int len,int byte_order)
{
    if ( byte_order == BYTEORDER_UNKNOWN ){
        return 0;
    }
    int l=0;
    int i,j;
    if ( buf[0] & 0x80){
	//Ǥѥå
	if ( l >= 8 ){
	    j = 7;
	}else{
	    return 0;
	}
    }else{
	j = 3;
    }
    for ( i = 0 ; i < j ; i++ ){
	l *= 256;
	l += buf[i+1];
    }
    return l*4+4;
}

RxPacket *createRxPacket(void *buf,int len,int byte_order)
{
    return new RxPacket_impl(buf,len,byte_order);
}
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
