<?php
/**
 * Aspect.class
 * 
 * @package aowp.aspect
 */
abstract class AOWP_Aspect {
	
	private static $_instance = null;
	
	private $_priority = 0;
	
	/**
	 * Advice.
	 */
	private $_adviceArray = array();

	public function getNumOfAdvice() {
		return count($this->_adviceArray);
	}
	
	public function getAdviceAt($idx) {
		return $this->_adviceArray[$idx];
	}
	
	/**
	 * Add Advice to $_adviceArray
	 * @param AOWP_Advice $advice
	 */
	public function addAdvice(AOWP_Advice $advice) {
		$adviceNextIndex = count($this->_adviceArray);
		$advice->setAspect($this);
		$advice->setIndex($adviceNextIndex);
		$this->_adviceArray[$adviceNextIndex] = $advice;
	}
	
	public function getAllAdviceArray() {
		return $this->_adviceArray;
	}
	
	public function runtimeMatch($index, AOWP_JoinPoint $joinPoint){
		return $this->_adviceArray[$index]->runtimeMatch($joinPoint);
	}
	
	public function executeAdvice($index, AOWP_JoinPoint &$joinPoint) {
		$adviceBodyName = $this->_adviceArray[$index]->getAdviceBodyFunctionName();
		return $this->$adviceBodyName($joinPoint);
	}
	
	/**
	 * 未実装 (ver. 0.8)
	 * 
	 * @param $priority
	 * @return unknown_type
	 */
	public function setPriority($priority) {
		$this->_priority = $priority;
	}
	/**
	 * 未実装 (ver. 0.8)
	 * 
	 * @return unknown_type
	 */
	public function getPriority() {
		return $this->_priority;
	}


}
?>
