<?php
/**
 * @package aowp.aspect
 */

/**
 * @package aowp.aspect
 */
class AOWP_ConfigurationManager {
	public static $WEAVING_TIME_FLAG = true;
	
	private static function _getConfigurationSamplePath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . 'ConfigurationSample.class.php';
	}
	private static function _getConfigurationPath() {
		return dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Configuration.class.php';
	}
	private static function _getRuntimeAutoloadplusFolder() {
		return AOWP_ConfigurationManager::getRuntimeSourcePath() . 'libs' . DIRECTORY_SEPARATOR .
			'autoloadplus' . DIRECTORY_SEPARATOR;
	}
	
	public static function getCacheFolder() {
		return AOWP_Configuration::RUNTIME_DATA_FOLDER . DIRECTORY_SEPARATOR;
	}
	public static function getRuntimeSourcePath() {
		return AOWP_Configuration::RUNTIME_DATA_FOLDER . DIRECTORY_SEPARATOR . 'sources' . DIRECTORY_SEPARATOR;
	}
	public static function getRuntimeIncludePath() {
		return AOWP_ConfigurationManager::_getRuntimeAutoloadplusFolder() . 'bin' . DIRECTORY_SEPARATOR . 'include.php';
	}
	
	public static function setupRuntimeEnvironment() {
		if (file_exists(AOWP_ConfigurationManager::getRuntimeSourcePath())) {
			AOWP_PHPFileManager::removeFolder(AOWP_ConfigurationManager::getRuntimeSourcePath());
		}
		AOWP_PHPFileManager::mkdir(AOWP_ConfigurationManager::getRuntimeSourcePath());
		AOWP_Logger::logging('Copy to runtime environment.');
		if (AOWP_PHPFileManager::_isWindows()) {
			AOWP_PHPFileManager::copy(AOWP_Configuration::AOWP_CLASS_PATH . DIRECTORY_SEPARATOR . 'classes', AOWP_ConfigurationManager::getRuntimeSourcePath() . 'classes');
			AOWP_PHPFileManager::copy(AOWP_Configuration::AOWP_CLASS_PATH . DIRECTORY_SEPARATOR . 'libs', AOWP_ConfigurationManager::getRuntimeSourcePath() . 'libs');
		}
		else {
			AOWP_PHPFileManager::copy(AOWP_Configuration::AOWP_CLASS_PATH . DIRECTORY_SEPARATOR . 'classes', AOWP_ConfigurationManager::getRuntimeSourcePath());
			AOWP_PHPFileManager::copy(AOWP_Configuration::AOWP_CLASS_PATH . DIRECTORY_SEPARATOR . 'libs', AOWP_ConfigurationManager::getRuntimeSourcePath());
		}
		include AOWP_ConfigurationManager::_getRuntimeAutoloadplusFolder() . 'bin' . DIRECTORY_SEPARATOR . 'autoloadplus.php';
	}
	
	/**
	 * This method generates and saves PHP file to define class for AOWP's configuration at weaving time and runtime.<br/>
	 * This method should be invoked before parsing PHP files and weaving defined aspects.
	 * 
	 * @param $aowpHome
	 * @param $projectPath
	 * @param $aspectPath
	 * @param $dataFolderName
	 * @param $includPattern
	 * @param $excludeFilePattern
	 */
	public static function setupConfiguration(
		$aowpHome,
		$projectPath,
		$aspectPath,
		$dataFolderName,
		$includPattern,
		$excludeFilePattern
	) {
		AOWP_Logger::setStartTime();
		$weavingDataFolder = $aowpHome . DIRECTORY_SEPARATOR . $dataFolderName;
		
		// Generate configuration files.
		$configSampleFilePath = AOWP_ConfigurationManager::_getConfigurationSamplePath();
		$sampleContent = file_get_contents($configSampleFilePath);
		$src = array(
			'%AOWP_CLASS_PATH%', 
			'%PROJECT_HOME_PATH%', 
			'%ASPECT_DIR_PATH%', 
			'%RUNTIME_DATA_FOLDER%', 
			'%INCLUDE_PHP_FILE_PATERN%', 
			'%EXCLUDE_PHP_FILE_PATERN%'
		);
		$dist = array(
			$aowpHome,
			$projectPath,
			$aspectPath,
			$projectPath . DIRECTORY_SEPARATOR . $dataFolderName,
			$includPattern,
			$excludeFilePattern
		);
		$configContent = str_replace($src, $dist, $sampleContent);
		$weavingConfigFilePath = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'Configuration.class.php';
		if (AOWP_PHPFileManager::saveFile($weavingConfigFilePath, $configContent)) {
			AOWP_Logger::logging('[Setup configuration] Configuration class is created.');
		}
		else {
			AOWP_Logger::logging('[Setup configuration] Failed to save configuration file.');
		}
	}
	
	
}
?>