<?php
/**
 * 
 * @package aowp.aspect.joinpoint
 */
/**
 * メソッド呼び出しを表すジョインポイントです。
 * 
 * @author keiji
 * @package aowp.aspect.joinpoint
 *
 */
class AOWP_MethodCallJoinPoint extends AOWP_JoinPointWithArguments {

	/**
	 * 呼び出されるオブジェクトです。
	 * 
	 * @var mixed
	 */
	private $_invokedObject;
	/**
	 * 呼び出すメソッド名です。
	 * 
	 * @var string
	 */
	private $_methodName;
	
	public function __construct(AOWP_PHPObjectPropertyElement $element = null, $fileName = null) {
		parent::__construct($element, $fileName);
		if ($element !== null) {
			$this->setMethodName($element->getPropertyName());
			$this->setStaticArgumentCount($element->getArgumentCount());
		}
	}
	
	public function setInvokedObject($invokedObject) {
		$this->_invokedObject = $invokedObject;
	}
	/**
	 * 呼び出されるオブジェクトを取得します。
	 * 
	 * @return mixed
	 */
	public function getInvokedObject() {
		return $this->_invokedObject;
	}
	
	public function setMethodName($methodName) {
		$this->_methodName = $methodName;
	}
	/**
	 * 呼び出すメソッド名を取得します。
	 * 
	 * @return string
	 */
	public function getMethodName() {
		return $this->_methodName;
	}

	public function proceed(array $argumentArray = array()) {
		if ($this->_proceedFunctionName !== null) {
			return call_user_func_array($this->_proceedFunctionName, array_merge(array($this), $argumentArray));
		}
	}
	
}
?>