<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * 現在、サポートされていません (ver. 0.8)。
 * 次期リリース予定です。
 * オブジェクトのフィールドへのアクセスを選択する、ポイントカット記述子です。
 * PHPでは、明示的に型付けが行われないため、実行時にオブジェクトの型をチェックしています。
 * 
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_FieldSetPointcut extends AOWP_Pointcut {
    private $_className;
    private $_fieldName;
	
	/**
	 * 
	 * @param string $className クラス名
	 * @param string $fieldName フィールド名
	 */
    public function __construct($className, $fieldName) {
    	$this->_className = $className;
    	$this->_fieldName = $fieldName;
    }
   
    protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
    	return $joinPoint instanceof AOWP_FieldSetJoinPoint &&
    		AOWP_Pointcut::patternMatch($this->_fieldName, $joinPoint->getFieldName());
    }

	protected function _runtimeMatch(AOWP_JoinPoint $joinPoint) {
		return AOWP_Pointcut::patternMatch($this->_className, get_class($joinPoint->getInvokedObject()));
	}
}
?>