<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * スクリプトファイルの実行を選択するポイントカット記述子です。
 * 
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_ScriptExecutionPointcut extends AOWP_StaticPointcut {
	private $_scriptName;
	
	/**
	 * Constructor.
	 */
	public function __construct ($scriptName) {
		$this->_scriptName = $scriptName;
	}
	
	protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
		return ($joinPoint instanceof AOWP_ScriptExecutionJoinPoint) &&
			AOWP_Pointcut::patternMatch($this->_scriptName, $joinPoint->getFileName());
	}

}
?>