﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace AppliStation.Util
{
	/// <summary>
	/// Description of OptionDialog.
	/// </summary>
	public partial class OptionDialog : Form
	{
		private object userInputValue = null;
		
		public OptionDialog()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
		}
		
		private void SomeButtonClick(object sender, EventArgs e)
		{
			this.Close();
		}
		
		private void HandleUserInput(object sender, EventArgs e)
		{
			TextBoxBase textBox = sender as TextBoxBase;
			RadioButton radioButton = sender as RadioButton;
			
			if (textBox != null) {
				this.userInputValue = textBox.Text;	
			}
			if (radioButton != null) {
				this.userInputValue = radioButton.Tag;	
			}
		}
		
		public string MainInstructionText {
			set {
				mainInstLabel.Text = value ?? string.Empty;
				mainInstLabel.Visible = ! string.IsNullOrEmpty(value);
			}
			get {	return mainInstLabel.Text;	}
		}
		public string ContentText {
			set {
				contentLabel.Text = value ?? string.Empty;
				contentLabel.Visible = ! string.IsNullOrEmpty(value);
			}
			get {	return mainInstLabel.Text;	}
		}
		public Image Image {
			set {
				iconPictureBox.Image = value;
				if (value != null) {
					iconPictureBox.Size = new Size(32, 32);
				} else {
					iconPictureBox.Size = new Size(0, 0);
				}
			}
			get {	return iconPictureBox.Image;	}
		}
		public MessageBoxButtons Buttons {
			set {
				okButton.Enabled	 = okButton.Visible		= (value == MessageBoxButtons.OK) || (value == MessageBoxButtons.OKCancel);
				cancelButton.Enabled = cancelButton.Visible	= (value == MessageBoxButtons.OKCancel) || (value == MessageBoxButtons.YesNoCancel);
				yesButton.Enabled	 = yesButton.Visible	= (value == MessageBoxButtons.YesNo) || (value == MessageBoxButtons.YesNoCancel);
				noButton.Enabled	 = noButton.Visible		= (value == MessageBoxButtons.YesNo) || (value == MessageBoxButtons.YesNoCancel);
				
				if (okButton.Enabled) {
					this.AcceptButton = okButton;
				} else if (yesButton.Enabled) {
					this.AcceptButton = yesButton;
				}
			}
			get {
				bool ok = okButton.Enabled;
				bool cancel = cancelButton.Enabled;
				bool yes = yesButton.Enabled;
				bool no = noButton.Enabled;
				
				if (ok && !cancel && !yes && !no) {
					return MessageBoxButtons.OK;
				} else if (ok && cancel && !yes && !no) {
					return MessageBoxButtons.OKCancel;
				} else if (!ok && !cancel && yes && no) {
					return MessageBoxButtons.YesNo;
				} else if (!ok && cancel && yes && no) {
					return MessageBoxButtons.YesNoCancel;
				} else {
					return (MessageBoxButtons) 0xFFFFu;
				}
			}
		}
		public Control.ControlCollection Content {
			get {	return contentFlowLayoutPanel.Controls;	}
		}
		
		public object UserInputValue {
			get { return userInputValue; }
		}
		
		public void BuildRadioButtons(string[] options, int initialOption) {
			this.Content.Clear();
			
			for (int i = 0; i < options.Length; i++) {
				RadioButton optRadios = new RadioButton();
				optRadios.Text = options[i];
				optRadios.Tag = i;
				optRadios.Click += HandleUserInput;
				optRadios.AutoSize = true;
				
				if (i == initialOption) {
					optRadios.Checked = true;
					this.userInputValue = initialOption;
				} else {
					optRadios.Checked = false;
				}
				
				this.Content.Add(optRadios);
			}
		}
		
		public static OptionDialog createMessageDialog(string message, string title, string mainInstruction, Icon icon)
		{
			return createOptionDialog(message, title, mainInstruction, icon, MessageBoxButtons.OK, null, -1);
		}
		
		public static OptionDialog createConfirmDialog(string message, string title, string mainInstruction, Icon icon, MessageBoxButtons buttons)
		{
			return createOptionDialog(message, title, mainInstruction, icon, buttons, null, -1);
		}
		
		public static OptionDialog createOptionDialog(string message, string title, string mainInstruction, Icon icon, MessageBoxButtons buttons, string[] options, int initialOption)
		{
			OptionDialog dialog = new OptionDialog();
			dialog.Text = title;
			dialog.ContentText = message;
			dialog.MainInstructionText = mainInstruction;
			dialog.Image = (icon != null)? icon.ToBitmap() : null;
			dialog.Buttons = buttons;
			
			if (options != null) {
				dialog.BuildRadioButtons(options, initialOption);
			}
			
			return dialog;
		}
		
		void OptionDialogStyleChanged(object sender, EventArgs e)
		{
			mainInstLabel.Font = SystemFonts.CaptionFont;
			if (System.Windows.Forms.VisualStyles.VisualStyleInformation.IsEnabledByUser) {
				mainInstLabel.ForeColor = Color.FromArgb(0x003399);
				
				this.BackColor = SystemColors.Window;
				this.ForeColor = SystemColors.WindowText;
				separatorLabel.Visible = true;
			} else {
				mainInstLabel.ForeColor = Color.Empty;
				
				this.BackColor = Color.Empty;
				this.ForeColor = Color.Empty;
				separatorLabel.Visible = false;
			}
		}
	}
}
