﻿using System;
using System.IO;

namespace NaGet.Packages
{
	/// <summary>
	/// パッケージ情報のファイルアクセスに関する例外
	/// </summary>
	public class PackageInformationFileAccessException : ApplicationException
	{
		string filePath;
		
		public PackageInformationFileAccessException(string msg, string filepath, Exception innerException)
			: base(msg, innerException)
		{
			this.filePath = filepath;
		}
		
		/// <summary>
		/// パッケージ情報のファイルへのパス
		/// </summary>
		public string FilePath {
			get { return filePath; }
		}
	}
}
