﻿using System;
using System.Threading;
using NUnit.Framework;

using NaGet.SubCommands.SubTask;

namespace test_na_get_lib
{
	[TestFixture]
	public class FunctionalSubTaskTest
	{
		[Test]
		public void UseProgress()
		{
			FunctionalSubTask<object> subtask = new FunctionalSubTask<object>(null, null);
			Assert.IsFalse(subtask.UseProgress);
		}
		
		[Test]
		public void Cancelable()
		{
			FunctionalSubTask<object> subtask = new FunctionalSubTask<object>(null, null);
			Assert.IsFalse(subtask.Cancelable);
		}
		
		[Test]
		public void Run()
		{
			object arg = new object();
			bool passBlock = false;
			FunctionalSubTask<object> subtask = null;
			
			// 正常動作
			
			Action<object> func1 = delegate (object argv) {
				passBlock = true;
				Assert.IsTrue(subtask.Running);
				Assert.IsFalse(subtask.Done);
				Assert.AreEqual(arg, argv);
			};
			subtask = new FunctionalSubTask<object>(func1, arg);
			passBlock = false;
			subtask.Run();
			Assert.IsFalse(subtask.Running);
			Assert.IsFalse(subtask.Cancelled);
			Assert.IsTrue(subtask.Done);
			Assert.IsTrue(passBlock);
			
			// 例外時動作
			
			Action<object> func2 = delegate (object argv) {
				passBlock = true;
				Assert.IsNull(argv);
				throw new TestException("foobar");
			};
			passBlock = false;
			subtask = new FunctionalSubTask<object>(func2, null);
			try {
				subtask.Run();
				Assert.IsTrue(passBlock);
				Assert.Fail("shall not be reached here");
			} catch (TestException ex) {
				Assert.IsTrue(passBlock);
				Assert.AreEqual("foobar", ex.Message);
			} finally {
				// 例外が起こったとしても終了扱い
				Assert.IsTrue(subtask.Done);
				Assert.IsFalse(subtask.Cancelled);
			}
			
			// 異常設定
			
			subtask = new FunctionalSubTask<object>(null, null);
			passBlock = false;
			try {
				subtask.Run();
				Assert.Fail("shall not be reached here");
			} catch (NullReferenceException) {
			} finally {
				// 例外が起こったとしても終了扱い
				Assert.IsTrue(subtask.Done);
				Assert.IsFalse(subtask.Cancelled);
			}
		}
		
		private class TestException : Exception
		{
			public TestException(string msg)
				: base(msg) {
			}
		}
	}
}
