#include "FrameScribble.h"
#include "Config.h"

//-----------------------------------------------------------------------------
// FrameScribble
//-----------------------------------------------------------------------------
FrameScribble::FrameScribble(wxWindow *pParent) :
	wxFrame(pParent, wxID_ANY, wxT("AScript Scribble"),
		Config::FrameScribble::ReadPosition(), Config::FrameScribble::ReadSize())
{
	wxMenuBar *pMenuBar = new wxMenuBar();
	SetMenuBar(pMenuBar);
	do {
		wxStatusBar *pStatusBar = new wxStatusBar(this, wxID_ANY, wxST_SIZEGRIP);
		SetStatusBar(pStatusBar);
	} while (0);
	_pPanel = new Panel(this, wxID_ANY);
	if (Config::FrameScribble::ReadShowFlag()) Show();
}

FrameScribble::~FrameScribble()
{
	Config::FrameScribble::WritePosition(GetPosition());
	Config::FrameScribble::WriteSize(GetSize());
	Config::FrameScribble::WriteShowFlag(IsShown());
}

void FrameScribble::ShowEx(bool flag)
{
	wxWindow *pWindow = wxWindow::FindFocus();
	Show(flag);
	pWindow->SetFocus();
}

BEGIN_EVENT_TABLE(FrameScribble, wxFrame)
	EVT_CLOSE(FrameScribble::OnClose)
END_EVENT_TABLE()

void FrameScribble::OnClose(wxCloseEvent &event)
{
	Show(false);
}

//-----------------------------------------------------------------------------
// FrameScribble::Panel
//-----------------------------------------------------------------------------
FrameScribble::Panel::Panel(wxWindow *pParent, wxWindowID id) :
		wxPanel(pParent, id, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{
	wxBoxSizer *pOuterBox = new wxBoxSizer(wxVERTICAL);
	SetSizer(pOuterBox);
	wxBoxSizer *pVBox = new wxBoxSizer(wxVERTICAL);
	pOuterBox->Add(pVBox, wxSizerFlags(1).Expand());
	do {
		PanelScribble *pCtrl = new PanelScribble(this, wxID_ANY, wxSUNKEN_BORDER);
		pVBox->Add(pCtrl, wxSizerFlags(1).Expand());
		_pPanelScribble = pCtrl;
	} while (0);
}

BEGIN_EVENT_TABLE(FrameScribble::Panel, wxPanel)
END_EVENT_TABLE()
