//-----------------------------------------------------------------------------
// AScript scribble module
//-----------------------------------------------------------------------------
#include <ascript.h>
#include "Application.h"

AScript_BeginModule(scribble)

//-----------------------------------------------------------------------------
// local properties
//-----------------------------------------------------------------------------
static struct {
	int burstLevel;
	wxPen *pPen;
	wxBrush *pBrush;
} g_prop = {
	0, NULL, NULL
};

AScript_DeclarePrivSymbol(fill)
AScript_DeclarePrivSymbol(solid)
AScript_DeclarePrivSymbol(dot)
AScript_DeclarePrivSymbol(dot_dash)
AScript_DeclarePrivSymbol(cross)
AScript_DeclarePrivSymbol(horizontal)
AScript_DeclarePrivSymbol(vertical)

inline PanelScribble *GetPanelScribble()
{
	return Application::GetInstance()->GetFrameScribble()->GetPanelScribble();
}

inline void ConditionalRefresh(PanelScribble *pPanelScribble)
{
	if (g_prop.burstLevel == 0) {
		pPanelScribble->Refresh();
		pPanelScribble->Update();
	}
}

//-----------------------------------------------------------------------------
// AScript module functions: scribble
//-----------------------------------------------------------------------------
// scribble.show(flag:boolean => true)
AScript_DeclareFunction(show)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "flag", VTYPE_Boolean, OCCUR_Once, false, false, new Expr_Value(true));
}

AScript_ImplementFunction(show)
{
	FrameScribble *pFrameScribble = Application::GetInstance()->GetFrameScribble();
	pFrameScribble->ShowEx(context.GetBoolean(0));
	return Value::Null;
}

// scribble.isshow()
AScript_DeclareFunction(isshown)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementFunction(isshown)
{
	FrameScribble *pFrameScribble = Application::GetInstance()->GetFrameScribble();
	return Value(pFrameScribble->IsShown()? true : false);
}

// scribble.refresh()
AScript_DeclareFunction(refresh)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementFunction(refresh)
{
	PanelScribble *pPanelScribble = GetPanelScribble();
	pPanelScribble->Refresh();
	pPanelScribble->Update();
	return Value::Null;
}

// scribble.burst() {block}
AScript_DeclareFunction(burst)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareBlock(OCCUR_Once);
}

AScript_ImplementFunction(burst)
{
	PanelScribble *pPanelScribble = GetPanelScribble();
	g_prop.burstLevel++;
	Value result = context.GetBlock()->Exec(env, sig);
	g_prop.burstLevel--;
	ConditionalRefresh(pPanelScribble);
	return result;
}

// scribble.clear()
AScript_DeclareFunction(clear)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementFunction(clear)
{
	PanelScribble *pPanelScribble = GetPanelScribble();
	do {
		wxMemoryDC dc(pPanelScribble->GetBitmap());
		dc.SetBrush(*wxWHITE_BRUSH);
		dc.Clear();
	} while (0);
	ConditionalRefresh(pPanelScribble);
	return Value::Null;
}

// scribble.setpen(color:string, width:number => 1, style:symbol => `solid):void
AScript_DeclareFunction(setpen)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "color", VTYPE_String);
	DeclareArg(env, "width", VTYPE_Number, OCCUR_Once, false, false,
							new Expr_Value(1));
	DeclareArg(env, "style", VTYPE_Symbol, OCCUR_Once, false, false,
							new Expr_Symbol(AScript_PrivSymbol(solid)));
}

AScript_ImplementFunction(setpen)
{
	delete g_prop.pPen;
	const Symbol *pSymbol = context.GetSymbol(2);
	g_prop.pPen = new wxPen(wxColour(context.GetString(0)), context.GetInt(1),
		pSymbol->IsIdentical(AScript_PrivSymbol(dot))? wxDOT :
		pSymbol->IsIdentical(AScript_PrivSymbol(dot_dash))? wxDOT_DASH :
		wxSOLID);
	return Value::Null;
}

// scribble.setbrush(color:string, style:symbol => `solid):void
AScript_DeclareFunction(setbrush)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "color", VTYPE_String);
	DeclareArg(env, "style", VTYPE_Symbol, OCCUR_Once, false, false,
							new Expr_Symbol(AScript_PrivSymbol(solid)));
}

AScript_ImplementFunction(setbrush)
{
	delete g_prop.pBrush;
	const Symbol *pSymbol = context.GetSymbol(1);
	g_prop.pBrush = new wxBrush(wxColour(context.GetString(0)),
		pSymbol->IsIdentical(AScript_PrivSymbol(cross))? wxCROSS_HATCH :
		pSymbol->IsIdentical(AScript_PrivSymbol(horizontal))? wxHORIZONTAL_HATCH :
		pSymbol->IsIdentical(AScript_PrivSymbol(vertical))? wxVERTICAL_HATCH :
		wxSOLID);
	return Value::Null;
}

// scribble.line(x1:number, y1:number, x2:number, y2:number):map:void
AScript_DeclareFunction(line)
{
	SetMode(RSLTMODE_Void, MAP_On, FLAT_Off);
	DeclareArg(env, "x1", VTYPE_Number);
	DeclareArg(env, "y1", VTYPE_Number);
	DeclareArg(env, "x2", VTYPE_Number);
	DeclareArg(env, "y2", VTYPE_Number);
}

AScript_ImplementFunction(line)
{
	PanelScribble *pPanelScribble = GetPanelScribble();
	do {
		wxMemoryDC dc(pPanelScribble->GetBitmap());
		dc.SetPen(*g_prop.pPen);
		dc.DrawLine(context.GetInt(0), context.GetInt(1), context.GetInt(2), context.GetInt(3));
	} while (0);
	ConditionalRefresh(pPanelScribble);
	return Value::Null;
}

// scribble.rectangle(x:number, y:number, width:number, height:number):map:void:[fill]
AScript_DeclareFunction(rectangle)
{
	SetMode(RSLTMODE_Void, MAP_On, FLAT_Off);
	DeclareArg(env, "x", VTYPE_Number);
	DeclareArg(env, "y", VTYPE_Number);
	DeclareArg(env, "width", VTYPE_Number);
	DeclareArg(env, "height", VTYPE_Number);
	DeclareAttr(AScript_PrivSymbol(fill));
}

AScript_ImplementFunction(rectangle)
{
	PanelScribble *pPanelScribble = GetPanelScribble();
	do {
		wxMemoryDC dc(pPanelScribble->GetBitmap());
		dc.SetPen(*g_prop.pPen);
		if (context.IsSet(AScript_PrivSymbol(fill))) {
			dc.SetBrush(*g_prop.pBrush);
		} else {
			dc.SetBrush(*wxTRANSPARENT_BRUSH);
		}
		dc.DrawRectangle(context.GetInt(0), context.GetInt(1), context.GetInt(2), context.GetInt(3));
	} while (0);
	ConditionalRefresh(pPanelScribble);
	return Value::Null;
}

// scribble.ellipse(x:number, y:number, width:number, height:number):map:void:[fill]
AScript_DeclareFunction(ellipse)
{
	SetMode(RSLTMODE_Void, MAP_On, FLAT_Off);
	DeclareArg(env, "x", VTYPE_Number);
	DeclareArg(env, "y", VTYPE_Number);
	DeclareArg(env, "width", VTYPE_Number);
	DeclareArg(env, "height", VTYPE_Number);
	DeclareAttr(AScript_PrivSymbol(fill));
}

AScript_ImplementFunction(ellipse)
{
	PanelScribble *pPanelScribble = GetPanelScribble();
	do {
		wxMemoryDC dc(pPanelScribble->GetBitmap());
		dc.SetPen(*g_prop.pPen);
		if (context.IsSet(AScript_PrivSymbol(fill))) {
			dc.SetBrush(*g_prop.pBrush);
		} else {
			dc.SetBrush(*wxTRANSPARENT_BRUSH);
		}
		dc.DrawEllipse(context.GetInt(0), context.GetInt(1), context.GetInt(2), context.GetInt(3));
	} while (0);
	ConditionalRefresh(pPanelScribble);
	return Value::Null;
}

// Module entry
AScript_ModuleEntry()
{
	g_prop.burstLevel = 0;
	g_prop.pPen = new wxPen(*wxBLACK, 1, wxSOLID);
	g_prop.pBrush = new wxBrush(*wxBLACK, wxSOLID);
	// symbol realization
	AScript_RealizePrivSymbol(fill);
	AScript_RealizePrivSymbol(solid)
	AScript_RealizePrivSymbol(dot)
	AScript_RealizePrivSymbol(dot_dash)
	AScript_RealizePrivSymbol(cross)
	AScript_RealizePrivSymbol(horizontal)
	AScript_RealizePrivSymbol(vertical)
	// function assignment
	AScript_AssignFunction(show);
	AScript_AssignFunction(isshown);
	AScript_AssignFunction(refresh);
	AScript_AssignFunction(burst);
	AScript_AssignFunction(clear);
	AScript_AssignFunction(setpen);
	AScript_AssignFunction(setbrush);
	AScript_AssignFunction(line);
	AScript_AssignFunction(rectangle);
	AScript_AssignFunction(ellipse);
}

AScript_ModuleTerminate()
{
}

AScript_EndModule(scribble)

AScript_RegisterModule(scribble)
