// OAL: OS Abstraction Layer
#ifndef __OAL_H__
#define __OAL_H__
#include "Common.h"
#if defined(HAVE_SEMAPHORE_H)
#include <semaphore.h>
#endif

namespace AScript {
namespace OAL {

const char *getenv(const char *name);
void rename(const char *src, const char *dst);
void remove(const char *pathName);
bool mkdir(const char *pathName, bool recursiveFlag);
bool chdir(const char *pathName);
String getcwd();
void exec(const char *pathName, const char **argv);
void Sleep(Number delay);

class Thread {
public:
	void Start();
	virtual void Run() = 0;
};

class Semaphore {
private:
#if defined(HAVE_WINDOWS_H)
	HANDLE _hMutex;
#elif defined(HAVE_SEMAPHORE_H)
	sem_t _sem;
#endif
public:
	Semaphore();
	~Semaphore();
	void Wait();
	void Release();
};

class Event {
private:
#if defined(HAVE_WINDOWS_H)
	HANDLE _hEvent;
#else
#endif
public:
	Event();
	~Event();
	void Wait();
	void Notify();
};

}
}

#endif
