#ifndef __OBJECT_TIMEDELTA_H__
#define __OBJECT_TIMEDELTA_H__

#include "Object.h"
#include "Environment.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_TimeDelta / Object_TimeDelta
//-----------------------------------------------------------------------------
class DLLEXPORT Class_TimeDelta : public Class {
public:
	Class_TimeDelta(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLEXPORT Object_TimeDelta : public Object {
public:
	inline static Object_TimeDelta *GetSelfObj(Context &context) {
		return dynamic_cast<Object_TimeDelta *>(context.GetSelfObj());
	}
private:
	TimeDelta _timeDelta;
public:
	inline Object_TimeDelta(Class *pClass, const TimeDelta &timeDelta) :
									Object(pClass), _timeDelta(timeDelta) {}
	Object_TimeDelta(const Object_TimeDelta &obj);
	virtual ~Object_TimeDelta();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline const TimeDelta &GetTimeDelta() const { return _timeDelta; }
};

}

#endif
