#ifndef __OBJECT_URI_H__
#define __OBJECT_URI_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_URI / Object_URI
//-----------------------------------------------------------------------------
class DLLEXPORT Class_URI : public Class {
public:
	Class_URI(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLEXPORT Object_URI : public Object {
public:
	inline static Object_URI *GetSelfObj(Context &context) {
		return dynamic_cast<Object_URI *>(context.GetSelfObj());
	}
private:
	bool _userValidFlag;
	String _scheme;
	String _user;
	String _password;
	String _host;
	String _port;
	String _urlpath;
	String _misc;
public:
	inline Object_URI(Class *pClass) : Object(pClass), _userValidFlag(false) {}
	Object_URI(const Object_URI &obj);
	virtual ~Object_URI();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	bool Parse(Signal sig, const char *str);
	inline bool IsUserValid() const { return _userValidFlag; }
	inline const char *GetScheme() const { return _scheme.c_str(); }
	inline const char *GetUser() const { return _user.c_str(); }
	inline const char *GetPassword() const { return _password.c_str(); }
	inline const char *GetHost() const { return _host.c_str(); }
	inline const char *GetPort() const { return _port.c_str(); }
	inline const char *GetUrlPath() const { return _urlpath.c_str(); }
	inline void SetScheme(const char *str) { _scheme = str; }
	inline void SetUser(const char *str) { _user = str, _userValidFlag = true; }
	inline void SetPassword(const char *str) { _password = str; }
	inline void SetHost(const char *str) { _host = str; }
	inline void SetPort(const char *str) { _port = str; }
	inline void SetUrlPath(const char *str) { _urlpath = str; }
	void SetError_InvalidURIFormat(Signal sig);
};

}

#endif
