/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.builtin.AwkTernaryArgs;
import net.morilib.awk.builtin.stat.AwkStatUtils;
import net.morilib.awk.builtin.stat.AwkStatisticsException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.stat.dist.continuous.TDistribution;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class T1TestBoth
extends AwkTernaryArgs {
    public T1TestBoth() {
        super("t1testboth");
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1, AwkValue a2, AwkValue a3) {
        double expected = a2.toFloat();
        double significance = a3.toFloat();
        if (significance < 0.0 || significance > 1.0) {
            throw new AwkStatisticsException("Invaild significance");
        }
        double[] obsv = AwkStatUtils.toDoubleValues(a1);
        int num = obsv.length;
        double mean = StatisticsUtils.mean(obsv);
        double var = StatisticsUtils.unbiasedVariance(obsv);
        double t = (mean - expected) / Math.sqrt(var / (double)num);
        TDistribution tdis = new TDistribution(num - 1);
        double min = tdis.invCdf(significance / 2.0);
        double max = tdis.invCdf(1.0 - significance / 2.0);
        return min < t && t < max ? AwkInteger.ONE : AwkInteger.ZERO;
    }
}

