/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.stat.dist.AbstractDiscreteDistribution;

public class Histogram
extends AbstractDiscreteDistribution {
    int[] frequency;
    double min;
    double max;
    double width;
    double mean;
    double variance;
    double mode;
    double median;
    double skewness;
    double kurtosis;
    int sum;

    public Histogram(double ... vals) {
        int k = (int)Math.sqrt(vals.length);
        this.min = StatisticsUtils.min(vals);
        this.max = StatisticsUtils.min(vals);
        this.width = (this.max - this.min) / (double)k;
        this.mean = StatisticsUtils.mean(vals);
        this.mode = StatisticsUtils.mode(vals);
        this.median = StatisticsUtils.median(vals);
        this.variance = StatisticsUtils.variance(vals);
        this.skewness = StatisticsUtils.skewness(vals);
        this.kurtosis = StatisticsUtils.kurtosis(vals);
        this.sum = vals.length;
        this.frequency = StatisticsUtils.toHistogram(vals);
    }

    public int getBins() {
        return this.frequency.length;
    }

    public int frequency(int n) {
        return this.frequency[n];
    }

    public double f(int n) {
        return this.frequency[n] / this.sum;
    }

    public double expectedValue() {
        return this.mean;
    }

    public double variance() {
        return this.variance;
    }

    public double mode() {
        return this.mode;
    }

    public double median() {
        return this.median;
    }

    public double skewness() {
        return this.skewness;
    }

    public double kurtosis() {
        return this.kurtosis;
    }

    public boolean isInSupport(int n) {
        return n >= 0 && n < this.frequency.length;
    }

    public int supportMinimum() {
        return 0;
    }
}

