/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist.discrete;

import net.morilib.awk.stat.dist.AbstractDiscreteDistribution;
import net.morilib.awk.stat.special.Gamma;

public class PoissonDistribution
extends AbstractDiscreteDistribution {
    private double lambda;

    public PoissonDistribution(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.lambda = lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    public double expectedValue() {
        return this.lambda;
    }

    public double variance() {
        return this.lambda;
    }

    public double mode() {
        return Math.IEEEremainder(this.lambda, 1.0) == 0.0 ? this.lambda - 1.0 : Math.floor(this.lambda);
    }

    public double median() {
        return Math.floor(this.lambda + 0.3333333333333333 - 0.02 / this.lambda);
    }

    public double skewness() {
        return 1.0 / Math.sqrt(this.lambda);
    }

    public double kurtosis() {
        return 1.0 / this.lambda;
    }

    public double f(int n) {
        if (n < 0) {
            return 0.0;
        }
        double r = Math.log(this.lambda) * (double)n - Gamma.lnGamma(n + 1) - this.lambda;
        return Math.exp(r);
    }

    public boolean isInSupport(int n) {
        return n >= 0;
    }

    public double cdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double l = Gamma.lnIncompleteGammaLower(Math.floor(x + 1.0), this.lambda);
        return 1.0 - Math.exp(l -= Gamma.lnGamma(Math.floor(x + 1.0)));
    }

    public int supportMinimum() {
        return 0;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.lambda);
    }

    public boolean equals(Object o) {
        if (o instanceof PoissonDistribution) {
            PoissonDistribution d = (PoissonDistribution)o;
            return this.lambda == d.lambda;
        }
        return false;
    }
}

