<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		AccessLogDate.class.php
 * @brief		月/日別アクセスクラス
 * @date		2007.02.07
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class AccessLogDate extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; アクセス数");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		// POSTデータが無い場合の初期値を設定
		if(!$_POST["view"])
			$_POST["view"] = "day";
		
		if(!$_POST["period"]["day"])
			$_POST["period"]["day"] = "30";
		
		if(!$_POST["period"]["mon"])
			$_POST["period"]["mon"] = "6";
		
		// ファイルからログ読み込み
		for($count = LOG_DIV; $count > 0; $count--)
		{
			if($fp = fopen(LOG_DIR."/log_".$_GET["group_code"]."_".$count.".dat","r"))
			{
				while(!feof($fp))
				{
					$log = fgets($fp);
					if(!is_bool($log))
					{
						// 抽出処理
						$temp = explode("\t",rtrim($log));
						if($_POST["view"] == "day")
						{
							$dt = mktime(0,0,0,date("n",$temp["0"]),date("j",$temp["0"]),date("Y",$temp["0"]));
						}
						else if($_POST["view"] == "mon")
						{
							$dt = mktime(0,0,0,date("n",$temp["0"]),1,date("Y",$temp["0"]));
						}
						$access_array[$dt]++;
						$user_array[$dt][$temp["1"]]++;
					}
				}
				fclose($fp);
			}
		}
		
		// 不要データを削除
		if($_POST["view"] == "day")
		{
			$st = mktime(0,0,0,date("n"),date("j")-intval($_POST["period"]["day"]),date("Y"));
			$et = mktime(0,0,0,date("n"),date("j"),date("Y"));
		}
		else if($_POST["view"] == "mon")
		{
			$st = mktime(0,0,0,date("n")-intval($_POST["period"]["mon"]),1,date("Y"));
			$et = mktime(0,0,0,date("n"),1,date("Y"));
		}
		foreach($access_array as $date => $count)
		{
			if($date < $st || $date >= $et)
			{
				unset($access_array[$date]);
			}
		}
		
		// ソート
		krsort($access_array);
		
		// ユーザー数をカウント
		foreach($user_array as $date => $user)
			$user_array[$date] = count($user);
		
		$this->assign("view",$_POST["view"]);
		$this->assign("period",$_POST["period"]);
		$this->assign("access_array",$access_array);
		$this->assign("user_array",$user_array);
		
		$this->template = "AccessLogDate.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
