<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		AccessLogTrans.class.php
 * @brief		ユーザ遷移クラス
 * @date		2007.02.07
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class AccessLogTrans extends PageRender
{
	function makePage()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; ユーザー遷移");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$this->current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$this->current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$this->current_group);
		
		// POSTデータが無い場合の初期値を設定
		if(!$_POST["view_user"])
			$_POST["view_user"] = "10";
		
		if(!$_POST["per_page"])
			$_POST["per_page"] = "10";
		
		// ファイルからログ読み込み
		for($count = LOG_DIV; $count > 0; $count--)
		{
			if($fp = fopen(LOG_DIR."/log_".$_GET["group_code"]."_".$count.".dat","r"))
			{
				while(!feof($fp))
				{
					$log = fgets($fp);
					if(!is_bool($log))
					{
						// 抽出処理
						$temp = explode("\t",rtrim($log));
						$tmp_user_array[] = $temp["1"];
						$log_array[$temp["1"]][] = array($temp["0"],preg_replace("/^\//",CURRENT_HTTP_SERVER,$temp["3"]),$temp["4"]);
					}
				}
				fclose($fp);
			}
		}
		
		// 重複レコード削除
		$tmp_user_array = array_unique($tmp_user_array);
		
		// ソート
		foreach($tmp_user_array as $user)
			$user_array[] = $user;
		foreach($log_array as $user => $array)
			usort($log_array[$user],"sort0desc");
		
		$this->assign("view_user",$_POST["view_user"]);
		$this->assign("per_page",$_POST["per_page"]);
		$this->assign("user_array",$user_array);
		$this->assign("log_array",$log_array);
		
		$this->template = "AccessLogTrans.tpl";
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
