<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		CategoryOrder.class.php
 * @brief		カテゴリのオーダー入れかえ
 * @date		2007.01.29
 */

require_once(CLASS_DIR."/PageRender.class.php");
require_once(CLASS_DIR."/adodb/CategoryManager.class.php");

class CategoryOrder extends PageRender
{
	function makePage()
	{
		$dao = new CategoryManager();
		$result = $dao->getNextPrevCategory($_GET["category_code"],"$dao->category.category_order desc","$dao->category.group_code = ".$_GET["group_code"]);
		
		if($_GET["move"] == "up")
			$target_code = $result["top"];
		else if($_GET["move"] == "down")
			$target_code = $result["bottom"];
		
		$dao->StartTrans();
		$dao->Lock();
		if($target_code)
			$dao->cngCategoryOrder($_GET["category_code"],$target_code);
		if(!$dao->CompleteTrans())
			$this->error("カテゴリの入れ替えに失敗しました。");
		
		$send_vars["mode"] = 15;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makePage();
		$this->renderPage();
	}
}
