<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		GeneralBCIE5CSSView.php
 * @brief		一般用CSSビュー(bitcube_ie5win.css)クラス
 * @date		2007.05.01
 */

require_once(CLASS_DIR."/ViewRender.class.php");
require_once(CLASS_DIR."/adodb/GeneralBCIE5CSSManager.class.php");

class GeneralBCIE5CSSView extends ViewRender
{
	function makeView()
	{
		$dao = new GeneralBCIE5CSSManager();
		$css = $dao->getBCIE5CSSInfo($_GET["group_code"]);
		if(!$css)
		{
			$this->error("Not Found");
		}
		$this->assignBitcubeTags($css["group_code"]);
		
		$this->register_resource("tpl");
		$this->template = "tpl:".$css["bitcube_ie5win_tmpl"];
	}
	
	function render()
	{
		$this->makeView();
		$this->renderView();
	}
}
