<?php
/* 
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		TemplateModuleEntry.class.php
 * @brief		モジュールテンプレートの新規登録クラス
 * @date		2007.01.24
 */

require_once(CLASS_DIR."/form/TemplateModuleInputForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");
require_once(CLASS_DIR."/adodb/TemplateModuleManager.class.php");

class TemplateModuleEntry extends TemplateModuleInputForm
{
	function makeForm()
	{
		$this->assign("TOPIC_PATH","<a href=\"./index.php?mode=3\">bitcube管理TOP</a> &gt; <a href=\"./index.php?mode=8&group_code=".$_GET["group_code"]."\">テンプレート一覧</a> &gt; テンプレート新規登録");
		
		$dao = new GroupManager();
		$group_array = $dao->getGroupList();
		$this->assign("group_array",$group_array);
		
		$current_group = $dao->getGroupInfo($_GET["group_code"]);
		if(!$current_group)
			$this->error("更新セット情報の取得に失敗しました。");
		$this->assign("current_group",$current_group);
		
		switch($_POST["state"])
		{
			case 1 :{$this->input();break;}		// 入力
			case 2 :{$this->confirm();break;}	// 確認
			case 3 :{$this->complete();break;}	// 完了
			default:{$this->input();break;}		// 入力
		}
	}
	
	// 入力
	function input()
	{
		$this->assign("state",2);
		$this->template = "TemplateModuleEntryInput.tpl";
	}
	
	// 確認
	function confirm()
	{
		$this->setModuleName($_POST["name"]);
		$form_error_array = $this->check();
		
		if((count($form_error_array) > 0) || ($_POST["back"]))
		{
			$this->assign("state",2);
			$this->assign("error_array",$form_error_array);
			$this->template = "TemplateModuleEntryInput.tpl";
		}
		else
		{
			$this->assign("state",3);
			$this->assign("message_array","下記の内容で登録します。よろしければ「登録」ボタンを押してください。<br />修正をする場合は「編集」ボタンよりお戻りください。");
			$this->template = "TemplateModuleEntryConfirm.tpl";
		}
		
		$this->assign("name",$_POST["name"]);
		$this->assign("body",$_POST["body"]); 
	}
	
	// 完了
	function complete()
	{
		$record = array();
		$record["group_code"] = $_GET["group_code"];
		$record["module_name"] = $_POST["name"];
		$record["module_body"] = $_POST["body"];
		
		$dao = new TemplateModuleManager();
		$dao->StartTrans();
		$dao->Lock();
		$dao->insTemplateModule($record);
		if(!$dao->CompleteTrans())
			$this->error("モジュールテンプレートの新規登録に失敗しました。");
		
		$send_vars["mode"] = 8;
		$send_vars["group_code"] = $_GET["group_code"];
		redirect(CURRENT_HTTP_SERVER.MANAGER."/index.php",$send_vars);
	}
	
	function render()
	{
		$this->makeForm();
		$this->renderForm();
	}
}
