<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		AccountInputForm.class.php
 * @brief		ユーザ設定入力フォームクラス
 * @date		2007.01.18
 */

require_once(CLASS_DIR."/form/AbstractForm.class.php");
require_once(CLASS_DIR."/adodb/GroupManager.class.php");

class AccountInputForm extends AbstractForm
{
	function setAccountName($account_name="")
	{
		$this->account_name = $account_name;
	}
	
	function setAccountPass($account_pass="")
	{
		$this->account_pass = $account_pass;
	}
	
	function setConfirmPass($confirm_pass="")
	{
		$this->confirm_pass = $confirm_pass;
	}
	
	function check()
	{
		$dao = new AccountManager();
		
		$error_array = array();
		if(!is_null($this->account_name))
			if(!strlen($this->account_name))
				$error_array["account_name"] = "ユーザ名を入力してください。";
			else if(!is_account($this->account_name))
				$error_array["account_name"] = "ユーザ名は半角英数字で入力してください。";
			else if($dao->findAccountName($this->account_name,$_SESSION["auth_username"]))
				$error_array["account_name"] = "既に存在するユーザ名です。";
		if(!is_null($this->account_pass))
			if(!strlen($this->account_pass))
				$error_array["account_pass"] = "パスワードを入力してください。";
			else if(!is_account($this->account_pass))
				$error_array["account_pass"] = "パスワードは半角英数字で入力してください。";
		if(!is_null($this->confirm_pass))
			if(!strlen($this->confirm_pass))
				$error_array["confirm_pass"] = "パスワード再入力を入力してください。";
		if((!is_null($this->account_pass)) && (!is_null($this->confirm_pass)))
			if($this->account_pass != $this->confirm_pass)
				$error_array["confirm_pass"] = "パスワードとパスワード再入力が一致していません。";
		return $error_array;
	}
}
