<?php
/*
 * Copyright(C). D-cube,Inc. All Rights Reserved.
 */

/*
 * @file		WriteLog.class.php
 * @brief		アクセスログ書き込みクラス
 * @date		2007.02.06
 */

class WriteLog
{
	function addLog($group_code,$title)
	{
		if((!is_null($_SERVER["REMOTE_ADDR"])) && (!is_null($_SERVER["REQUEST_URI"])))
		{
			// アクセス時間取得
			$access_time = (!is_null($_SERVER["REQUEST_TIME"])) ?
				$_SERVER["REQUEST_TIME"] :
				time();
			
			// ファイルが無ければ生成
			if(!is_dir(LOG_DIR))
			{
				mkdir(LOG_DIR);
				if($fp = fopen(LOG_DIR."/log_".$group_code."_1.dat","w"))
				{
					ftruncate($fp,0);
					fclose($fp);
				}
			}
			
			// 書き込み処理
			if($fp = fopen(LOG_DIR."/log_".$group_code."_1.dat","a"))
			{
				if(flock($fp,LOCK_EX))
				{
					fputs($fp,$access_time."\t".preg_replace("/^BC/","",crypt($_SERVER["REMOTE_ADDR"],"BC"))."\t".$_SERVER["HTTP_REFERER"]."\t".$_SERVER["REQUEST_URI"]."\t".$title."\n");
					flock($fp,LOCK_UN);
				}
				fclose($fp);
			}
			
			// 過去ログ生成
			if(filesize(LOG_DIR."/log_".$group_code."_1.dat") > (LOG_SIZE / LOG_DIV))
			{
				unlink(LOG_DIR."/log_".$group_code."_".LOG_DIV.".dat");
				for($count = (LOG_DIV - 1); $count > 0; $count--)
					rename(LOG_DIR."/log_".$group_code."_".$count.".dat",LOG_DIR."/log_".$group_code."_".($count + 1).".dat");
			}
		}
	}
}
