<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty mbtruncate modifier plugin
 *
 * Type:     modifier<br>
 * Name:     mbtruncate<br>
 * Purpose:  truncate修正子のマルチバイト対応版
 * @author   Yuki Yoshioka
 * @param string
 * @param integer
 * @param string
 * @param boolean
 * @return string
 */
function smarty_modifier_mbtruncate($string, $length = 80, $etc = '...', $middle = false)
{
	if($length == 0)
	{
		return '';
	}

	if(mb_strlen($string) > $length)
	{
		$length -= mb_strlen($etc);
		
		if(!$middle)
		{
            return mb_substr($string,0,$length).$etc;
		}
		else
		{
			return mb_substr($string, 0, $length/2).$etc.mb_substr($string,-$length/2);
		}
	}
	else
	{
		return $string;
	}
}

/* vim: set expandtab: */

?>
