/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.tokenizer;

import org.dts.spell.filter.Filter;
import org.dts.spell.finder.Word;
import org.dts.spell.tokenizer.AbstractWordTokenizer;
import org.dts.spell.tokenizer.DefaultWordTokenizer;
import org.dts.spell.tokenizer.WordTokenizer;

public class FilteredTokenizer
extends AbstractWordTokenizer {
    private Filter filter;
    private WordTokenizer tokenizer;

    public FilteredTokenizer(Filter filter) {
        this(filter, new DefaultWordTokenizer());
    }

    public FilteredTokenizer(Filter filter, WordTokenizer tokenizer) {
        this.filter = filter;
        this.tokenizer = tokenizer;
    }

    public Word currentWord(int index) {
        return this.filter(this.tokenizer.currentWord(index));
    }

    private Word tokenizerCurrentWord(int index) {
        if (index < 0 || this.getCharSequence().length() <= index) {
            return null;
        }
        return this.tokenizer.currentWord(index);
    }

    private int nextIndex(Word currentWord, int index) {
        if (currentWord != null) {
            index = currentWord.getEnd();
        }
        return ++index;
    }

    public Word nextWord(int index) {
        Word current;
        int length = this.getCharSequence().length();
        Word currentNoFiltered = this.tokenizer.currentWord(index);
        Word orgWord = current = this.filter(currentNoFiltered);
        Word result = null;
        while (index < length && current == null) {
            index = this.nextIndex(currentNoFiltered, index);
            currentNoFiltered = this.tokenizerCurrentWord(index);
            current = this.filter(currentNoFiltered);
        }
        if (index < length && current != null) {
            if (current.equals(orgWord)) {
                index = orgWord.getEnd();
                while (index < length && result == null) {
                    if (current != null && !current.equals(orgWord)) {
                        result = current;
                        continue;
                    }
                    index = this.nextIndex(currentNoFiltered, index);
                    currentNoFiltered = this.tokenizerCurrentWord(index);
                    current = this.filter(currentNoFiltered);
                }
            } else {
                result = current;
            }
        }
        return result;
    }

    private int previousIndex(Word currentWord, int index) {
        if (currentWord != null) {
            index = currentWord.getStart();
        }
        return --index;
    }

    public Word previousWord(int index) {
        Word current;
        Word currentNoFiltered = this.tokenizer.currentWord(index);
        Word orgWord = current = this.filter(currentNoFiltered);
        Word result = null;
        while (index > 0 && current == null) {
            index = this.previousIndex(currentNoFiltered, index);
            currentNoFiltered = this.tokenizerCurrentWord(index);
            current = this.filter(currentNoFiltered);
        }
        if (index > 0 && current != null) {
            if (current.equals(orgWord)) {
                index = orgWord.getStart();
                while (index > 0 && result == null) {
                    if (current != null && !current.equals(orgWord)) {
                        result = current;
                        continue;
                    }
                    index = this.previousIndex(currentNoFiltered, index);
                    currentNoFiltered = this.tokenizerCurrentWord(index);
                    current = this.filter(currentNoFiltered);
                }
            } else {
                result = current;
            }
        }
        return result;
    }

    public void updateCharSequence(int start, int end, int cause) {
        this.tokenizer.updateCharSequence(start, end, cause);
        this.filter.updateCharSequence(this.tokenizer, start, end, cause);
    }

    public void setCharSequence(CharSequence sequence) {
        this.tokenizer.setCharSequence(sequence);
        super.setCharSequence(sequence);
    }

    protected Word filter(Word word) {
        if (word != null) {
            return this.filter.filter(word, this.tokenizer);
        }
        return null;
    }
}

