/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation.datamodels;

import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.table.AbstractTableModel;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.OStrings;

public class SegmentationRulesModel
extends AbstractTableModel {
    private List rules;
    private static String[] COLUMN_NAMES = new String[]{OStrings.getString("CORE_SRX_TABLE_COLUMN_Break"), OStrings.getString("CORE_SRX_TABLE_COLUMN_Before_Break"), OStrings.getString("CORE_SRX_TABLE_COLUMN_After_Break")};
    protected List listeners = new ArrayList();

    public SegmentationRulesModel(List list) {
        this.rules = list;
    }

    public Object getValueAt(int n, int n2) {
        Rule rule = (Rule)this.rules.get(n);
        switch (n2) {
            case 0: {
                return new Boolean(rule.isBreakRule());
            }
            case 1: {
                return rule.getBeforebreak();
            }
            case 2: {
                return rule.getAfterbreak();
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.rules.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    public void setValueAt(Object object, int n, int n2) {
        Rule rule = (Rule)this.rules.get(n);
        switch (n2) {
            case 0: {
                rule.setBreakRule((Boolean)object);
                break;
            }
            case 1: {
                try {
                    rule.setBeforebreak((String)object);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.fireException(patternSyntaxException);
                }
                break;
            }
            case 2: {
                try {
                    rule.setAfterbreak((String)object);
                    break;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    this.fireException(patternSyntaxException);
                }
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public int addRow() {
        int n = this.rules.size();
        this.rules.add(new Rule(false, "\\.", "\\s"));
        this.fireTableRowsInserted(n, n);
        return n;
    }

    public void removeRow(int n) {
        this.rules.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void moveRowUp(int n) {
        Object e = this.rules.get(n - 1);
        Object e2 = this.rules.get(n);
        this.rules.remove(n - 1);
        this.rules.add(n, e);
        this.fireTableRowsUpdated(n - 1, n);
    }

    public void moveRowDown(int n) {
        Object e = this.rules.get(n + 1);
        Object e2 = this.rules.get(n);
        this.rules.remove(n + 1);
        this.rules.add(n, e);
        this.fireTableRowsUpdated(n, n + 1);
    }

    public void addExceptionListener(ExceptionListener exceptionListener) {
        this.listeners.add(exceptionListener);
    }

    public void removeTableModelListener(ExceptionListener exceptionListener) {
        this.listeners.remove(exceptionListener);
    }

    public void fireException(Exception exception) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ExceptionListener exceptionListener = (ExceptionListener)this.listeners.get(i);
            exceptionListener.exceptionThrown(exception);
        }
    }
}

