/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.LegacyTM;
import org.omegat.core.ProjectProperties;
import org.omegat.core.StringEntry;
import org.omegat.core.TransMemory;
import org.omegat.core.glossary.GlossaryManager;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.SourceTextEntry;
import org.omegat.core.spellchecker.SpellChecker;
import org.omegat.core.threads.SaveThread;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.ProjectFrame;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.messages.MessageRelay;
import org.omegat.util.LFileCopy;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileData;
import org.omegat.util.RequestPacket;
import org.omegat.util.StaticUtils;
import org.omegat.util.TMXReader;

public class CommandThread
extends Thread {
    public static CommandThread core;
    private static final SpellChecker m_spellchecker;
    private boolean projectClosing = false;
    private static final int MAX_BACKUPS = 10;
    private SaveThread m_saveThread;
    private int m_saveCount;
    private ProjectProperties m_config;
    private boolean m_modifiedFlag;
    private int numberofTranslatedSegments;
    private boolean _dontCountNext = false;
    private LinkedList m_requestQueue;
    private ProjectFileData m_curFile;
    MainWindow m_transFrame;
    private ProjectFrame m_projWin;
    private HashMap m_strEntryHash;
    private ArrayList m_strEntryList;
    private ArrayList m_srcTextEntryArray;
    private List m_legacyTMs;
    private ArrayList m_tmList;
    private ArrayList m_orphanedList;
    private ArrayList m_extensionList;
    private ArrayList m_extensionMapList;
    private GlossaryManager m_glossary;

    public SpellChecker getSpellchecker() {
        return m_spellchecker;
    }

    public CommandThread(MainWindow mainWindow) {
        this.setName("Command thread");
        this.setPriority(1);
        this.m_transFrame = mainWindow;
        this.m_projWin = mainWindow.getProjectFrame();
        this.m_config = new ProjectProperties();
        this.m_strEntryHash = new HashMap(4096);
        this.m_strEntryList = new ArrayList();
        this.m_srcTextEntryArray = new ArrayList(4096);
        this.m_tmList = new ArrayList();
        this.m_legacyTMs = new ArrayList();
        this.m_orphanedList = new ArrayList();
        this.m_modifiedFlag = false;
        this.m_extensionList = new ArrayList(32);
        this.m_extensionMapList = new ArrayList(32);
        this.m_requestQueue = new LinkedList();
        this.m_saveCount = -1;
        this.m_saveThread = null;
    }

    public void run() {
        RequestPacket requestPacket = new RequestPacket();
        this.m_saveThread = new SaveThread();
        try {
            while (!CommandThread.interrupted()) {
                try {
                    CommandThread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
                requestPacket.reset();
                this.messageBoardCheck(requestPacket);
                switch (requestPacket.type) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.requestLoad(requestPacket);
                        break;
                    }
                    case 3: {
                        this.save();
                    }
                }
            }
            Preferences.save();
            this.m_saveThread.interrupt();
            try {
                CommandThread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
            core = null;
        }
        catch (RuntimeException runtimeException) {
            this.forceSave(true);
            String string = OStrings.getString("CT_FATAL_ERROR");
            this.m_transFrame.fatalError(string, runtimeException);
        }
    }

    public synchronized void messageBoardPost(RequestPacket requestPacket) {
        this.messageBoard(true, requestPacket);
    }

    private synchronized void messageBoardCheck(RequestPacket requestPacket) {
        this.messageBoard(false, requestPacket);
    }

    private synchronized void messageBoard(boolean bl, RequestPacket requestPacket) {
        if (core == null) {
            return;
        }
        if (bl) {
            this.m_requestQueue.add(requestPacket);
        } else if (this.m_requestQueue.size() > 0) {
            requestPacket.set((RequestPacket)this.m_requestQueue.removeFirst());
        }
    }

    public void cleanUp() {
        if (this.m_strEntryList.size() > 0) {
            if (this.m_saveCount >= 0) {
                this.m_saveCount = 1;
            }
            this.save();
        }
        this.m_strEntryHash.clear();
        this.m_legacyTMs.clear();
        this.m_tmList.clear();
        this.m_orphanedList.clear();
        this.m_extensionList.clear();
        this.m_extensionMapList.clear();
        this.m_strEntryList.clear();
        this.m_srcTextEntryArray.clear();
        if (this.m_projWin != null) {
            if (this.m_projWin.isVisible()) {
                this.m_projWin.setVisible(false);
            }
            this.m_projWin.reset();
        }
        this.numberofTranslatedSegments = 0;
        m_spellchecker.destroy();
    }

    private void requestLoad(RequestPacket requestPacket) {
        MainWindow mainWindow = (MainWindow)requestPacket.obj;
        try {
            this.cleanUp();
            String string = OStrings.getString("CT_LOADING_PROJECT");
            MessageRelay.uiMessageSetMessageText(mainWindow, string);
            if (!this.loadProject((String)requestPacket.parameter)) {
                string = OStrings.getString("CT_CANCEL_LOAD");
                MessageRelay.uiMessageSetMessageText(mainWindow, string);
                return;
            }
            mainWindow.finishLoadProject();
            MessageRelay.uiMessageDisplayEntry(mainWindow);
            if (this.m_saveCount == -1) {
                this.m_saveThread.start();
                this.m_saveCount = 1;
            }
            string = OStrings.getString("CT_LOADING_GLOSSARIES");
            MessageRelay.uiMessageSetMessageText(mainWindow, string);
            this.m_glossary.buildGlossary(this.m_strEntryList);
            MessageRelay.uiMessageSetMessageText(mainWindow, OStrings.getString("CT_LOADING_PROJECT"));
            try {
                this.loadTM();
            }
            catch (IOException iOException) {
                String string2 = OStrings.getString("TF_TM_LOAD_ERROR");
                this.displayError(string2, iOException);
            }
            this.buildNearList();
            this.buildProjectStats();
            MessageRelay.uiMessageSetMessageText(mainWindow, "");
            this.m_transFrame.projectLoaded();
            this.m_saveCount = 2;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            if (!this.projectClosing) {
                this.displayError(OStrings.getString("TF_LOAD_ERROR"), exception);
            } else {
                Log.logRB("CT_CANCEL_LOAD");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.m_strEntryHash.clear();
            this.m_strEntryHash = null;
            this.m_strEntryList.clear();
            this.m_strEntryList = null;
            this.m_srcTextEntryArray.clear();
            this.m_srcTextEntryArray = null;
            this.m_legacyTMs.clear();
            this.m_legacyTMs = null;
            this.m_tmList.clear();
            this.m_tmList = null;
            this.m_orphanedList.clear();
            this.m_orphanedList = null;
            this.m_extensionList.clear();
            this.m_extensionList = null;
            this.m_extensionMapList.clear();
            this.m_extensionMapList = null;
            this.m_glossary = null;
            System.gc();
            Log.logErrorRB("OUT_OF_MEMORY");
            Log.log(outOfMemoryError);
            this.m_transFrame.displayError(OStrings.getString("OUT_OF_MEMORY"), outOfMemoryError);
            System.exit(0);
        }
    }

    public void signalProjectClosing() {
        this.projectClosing = true;
    }

    private synchronized void buildTMXFile(String string, boolean bl, boolean bl2) throws IOException {
        this.buildTMXFile(string, bl, bl2, false);
    }

    private synchronized void buildTMXFile(String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string2 = Preferences.getPreference("source_lang");
        String string3 = Preferences.getPreference("target_lang");
        String string4 = this.m_config.isSentenceSegmentingEnabled() ? "sentence" : "paragraph";
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        String string5 = OStrings.VERSION;
        if (!OStrings.UPDATE.equals("0")) {
            string5 = string5 + "_" + OStrings.UPDATE;
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (bl3) {
            printWriter.println("<!DOCTYPE tmx SYSTEM \"tmx14.dtd\">");
        } else {
            printWriter.println("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">");
        }
        if (bl3) {
            printWriter.println("<tmx version=\"1.4\">");
        } else {
            printWriter.println("<tmx version=\"1.1\">");
        }
        printWriter.println("  <header");
        printWriter.println("    creationtool=\"OmegaT\"");
        printWriter.println("    creationtoolversion=\"" + string5 + "\"");
        printWriter.println("    segtype=\"" + string4 + "\"");
        printWriter.println("    o-tmf=\"OmegaT TMX\"");
        printWriter.println("    adminlang=\"EN-US\"");
        printWriter.println("    srclang=\"" + string2 + "\"");
        printWriter.println("    datatype=\"plaintext\"");
        printWriter.println("  >");
        printWriter.println("  </header>");
        printWriter.println("  <body>");
        String string6 = bl3 ? "xml:lang" : "lang";
        String string7 = null;
        String string8 = null;
        for (int i = 0; i < this.m_strEntryList.size(); ++i) {
            StringEntry stringEntry = (StringEntry)this.m_strEntryList.get(i);
            string7 = bl ? StaticUtils.stripTags(stringEntry.getSrcText()) : stringEntry.getSrcText();
            String string9 = string8 = bl ? StaticUtils.stripTags(stringEntry.getTranslation()) : stringEntry.getTranslation();
            if (string8.length() == 0) continue;
            string7 = StaticUtils.makeValidXML(string7);
            string8 = StaticUtils.makeValidXML(string8);
            if (bl3) {
                string7 = this.makeLevelTwo(string7);
                string8 = this.makeLevelTwo(string8);
            }
            printWriter.println("    <tu>");
            printWriter.println("      <tuv " + string6 + "=\"" + string2 + "\">");
            printWriter.println("        <seg>" + string7 + "</seg>");
            printWriter.println("      </tuv>");
            printWriter.println("      <tuv " + string6 + "=\"" + string3 + "\">");
            printWriter.println("        <seg>" + string8 + "</seg>");
            printWriter.println("      </tuv>");
            printWriter.println("    </tu>");
        }
        if (bl2) {
            for (int i = 0; i < this.m_orphanedList.size(); ++i) {
                TransMemory transMemory = (TransMemory)this.m_orphanedList.get(i);
                if (transMemory.target.length() == 0) continue;
                string7 = bl ? StaticUtils.stripTags(transMemory.source) : transMemory.source;
                String string10 = string8 = bl ? StaticUtils.stripTags(transMemory.target) : transMemory.target;
                if (bl3) {
                    string7 = this.makeLevelTwo(string7);
                    string8 = this.makeLevelTwo(string8);
                }
                if (string8.length() == 0) continue;
                string7 = StaticUtils.makeValidXML(string7);
                string8 = StaticUtils.makeValidXML(string8);
                printWriter.println("    <tu>");
                printWriter.println("      <tuv " + string6 + "=\"" + string2 + "\">");
                printWriter.println("        <seg>" + string7 + "</seg>");
                printWriter.println("      </tuv>");
                printWriter.println("      <tuv " + string6 + "=\"" + string3 + "\">");
                printWriter.println("        <seg>" + string8 + "</seg>");
                printWriter.println("      </tuv>");
                printWriter.println("    </tu>");
            }
        }
        printWriter.println("  </body>");
        printWriter.println("</tmx>");
        printWriter.close();
    }

    private String makeLevelTwo(String string) {
        boolean bl;
        String string2;
        String string3;
        String string4;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        Matcher matcher = Pattern.compile("\\d+").matcher("");
        Matcher matcher2 = Pattern.compile("&lt;[\\S&&[^/\\d]]+(\\d+)/&gt;").matcher(string);
        int n = 0;
        while (matcher2.find()) {
            string4 = matcher2.group();
            string3 = matcher2.group(1);
            stringBuffer.append(string.substring(n, matcher2.start()));
            stringBuffer.append("<ph x='");
            stringBuffer.append(string3);
            stringBuffer.append("'>");
            stringBuffer.append(string4);
            stringBuffer.append("</ph>");
            n = matcher2.end();
        }
        stringBuffer.append(string.substring(n, string.length()));
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        matcher2 = Pattern.compile("&lt;[\\S&&[^/\\d]]+(\\d+)&gt;").matcher(string);
        n = 0;
        while (matcher2.find()) {
            string4 = matcher2.group();
            string3 = matcher2.group(1);
            string2 = "&lt;/" + string4.substring(4);
            bl = string.indexOf(string2) > -1;
            stringBuffer.append(string.substring(n, matcher2.start()));
            if (bl) {
                stringBuffer.append("<bpt i='");
                stringBuffer.append(string3);
                stringBuffer.append("'");
            } else {
                stringBuffer.append("<it pos='begin'");
            }
            stringBuffer.append(" x='");
            stringBuffer.append(string3);
            stringBuffer.append("'>");
            stringBuffer.append(string4);
            stringBuffer.append(bl ? "</bpt>" : "</it>");
            n = matcher2.end();
        }
        stringBuffer.append(string.substring(n, string.length()));
        string = stringBuffer.toString();
        stringBuffer.setLength(0);
        matcher2 = Pattern.compile("&lt;/[\\S&&[^\\d]]+(\\d+)&gt;").matcher(string);
        n = 0;
        while (matcher2.find()) {
            string4 = matcher2.group();
            string3 = matcher2.group(1);
            string2 = "&lt;" + string4.substring(5);
            bl = string.indexOf(string2) > -1;
            stringBuffer.append(string.substring(n, matcher2.start()));
            stringBuffer.append(bl ? "<ept i='" : "<it pos='end' x='");
            stringBuffer.append(string3);
            stringBuffer.append("'>");
            stringBuffer.append(string4);
            stringBuffer.append(bl ? "</ept>" : "</it>");
            n = matcher2.end();
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    public ArrayList validateTags() {
        ArrayList arrayList = new ArrayList(32);
        ArrayList arrayList2 = new ArrayList(32);
        ArrayList<SourceTextEntry> arrayList3 = new ArrayList<SourceTextEntry>(16);
        for (int i = 0; i < this.numEntries(); ++i) {
            SourceTextEntry sourceTextEntry = (SourceTextEntry)this.m_srcTextEntryArray.get(i);
            StringEntry stringEntry = sourceTextEntry.getStrEntry();
            String string = stringEntry.getSrcText();
            String string2 = stringEntry.getTranslation();
            if (string2 == null || string2.length() == 0) continue;
            StaticUtils.buildTagList(string, arrayList);
            StaticUtils.buildTagList(string2, arrayList2);
            if (arrayList.size() != arrayList2.size()) {
                arrayList3.add(sourceTextEntry);
            } else {
                for (int j = 0; j < arrayList.size(); ++j) {
                    string = (String)arrayList.get(j);
                    if (string.equals(string2 = (String)arrayList2.get(j))) continue;
                    arrayList3.add(sourceTextEntry);
                    break;
                }
            }
            arrayList.clear();
            arrayList2.clear();
        }
        return arrayList3;
    }

    public void compileProject() throws IOException, TranslationException {
        Object object;
        Object object2;
        Object object3;
        if (this.m_strEntryHash.size() == 0) {
            return;
        }
        this.save();
        try {
            object3 = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-omegat" + ".tmx";
            this.buildTMXFile((String)object3, false, false);
            object3 = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-level1" + ".tmx";
            this.buildTMXFile((String)object3, true, false);
            object3 = this.m_config.getProjectRoot() + this.m_config.getProjectName() + "-level2" + ".tmx";
            this.buildTMXFile((String)object3, false, false, true);
        }
        catch (IOException iOException) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX");
            Log.log(iOException);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + iOException.getMessage());
        }
        object3 = new ArrayList(256);
        String string = this.m_config.getSourceRoot();
        String string2 = this.m_config.getTargetRoot();
        StaticUtils.buildDirList((ArrayList)object3, new File(string));
        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
            object2 = (String)((ArrayList)object3).get(i);
            String string3 = string2 + ((String)object2).substring(string.length());
            object = new File(string3);
            if (((File)object).exists() || ((File)object).mkdir()) continue;
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TARGET_DIR") + string3);
        }
        FilterMaster filterMaster = FilterMaster.getInstance();
        ((ArrayList)object3).clear();
        StaticUtils.buildFileList((ArrayList)object3, new File(string), true);
        object2 = new HashSet();
        for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
            object = (String)((ArrayList)object3).get(i);
            File file = new File((String)object);
            if (object2.contains(file)) continue;
            String string4 = ((String)object).substring(string.length());
            this.m_transFrame.setMessageText(StaticUtils.format(OStrings.getString("CT_COMPILE_FILE_MX"), new Object[]{string4}));
            filterMaster.translateFile(string, string4, string2, (Set)object2);
        }
        this.m_transFrame.setMessageText(OStrings.getString("CT_COMPILE_DONE_MX"));
    }

    public void save() {
        if (this.isProjectModified()) {
            this.forceSave(false);
        }
    }

    public synchronized void markAsDirty() {
        this.m_modifiedFlag = true;
    }

    private void forceSave(boolean bl) {
        File file;
        String string;
        block8: {
            Object object;
            Preferences.save();
            if (this.m_saveCount <= 0) {
                return;
            }
            if (this.m_saveCount == 1) {
                this.m_saveCount = 0;
            }
            string = this.m_config.getProjectInternal() + "project_save.tmx";
            if (bl) {
                string = string + ".recover";
            } else {
                file = new File(string + ".backup");
                object = new File(string);
                if (((File)object).exists()) {
                    ((File)object).renameTo(file);
                }
            }
            try {
                this.buildTMXFile(string, false, true);
                this.m_modifiedFlag = false;
            }
            catch (IOException iOException) {
                object = OStrings.getString("CT_ERROR_SAVING_PROJ");
                this.displayError((String)object, iOException);
                if (bl) break block8;
                string = this.m_config.getProjectInternal() + "project_save.tmx";
                File file2 = new File(string + ".backup");
                File file3 = new File(string);
                if (!file2.exists()) break block8;
                file2.renameTo(file3);
            }
        }
        if (!this.m_modifiedFlag && !bl && (file = new File((string = this.m_config.getProjectInternal() + "project_save.tmx") + ".backup")).exists()) {
            file.delete();
        }
        this.buildProjectStats();
    }

    public synchronized void addEntry(String string) {
        if (string.length() == 0 || string.trim().length() == 0) {
            return;
        }
        StringEntry stringEntry = (StringEntry)this.m_strEntryHash.get(string);
        if (stringEntry == null) {
            stringEntry = new StringEntry(string);
            this.m_strEntryList.add(stringEntry);
            this.m_strEntryHash.put(string, stringEntry);
        }
        SourceTextEntry sourceTextEntry = new SourceTextEntry(stringEntry, this.m_curFile, this.numEntries());
        this.m_srcTextEntryArray.add(sourceTextEntry);
    }

    public void createProject() {
        try {
            if (!this.m_config.createNew(this.m_transFrame)) {
                return;
            }
            File file = new File(this.m_config.getProjectRoot());
            if (!file.isDirectory() && !file.mkdirs()) {
                String string = OStrings.getString("CT_ERROR_CREATE");
                throw new IOException(string);
            }
            File file2 = new File(this.m_config.getProjectInternal());
            if (!file2.isDirectory() && !file2.mkdirs()) {
                String string = OStrings.getString("CT_ERROR_CREATE");
                throw new IOException(string);
            }
            File file3 = new File(this.m_config.getSourceRoot());
            if (!file3.isDirectory() && !file3.mkdirs()) {
                String string = OStrings.getString("CT_ERROR_CREATE") + "\n(.../src/)";
                throw new IOException(string);
            }
            File file4 = new File(this.m_config.getGlossaryRoot());
            if (!file4.isDirectory() && !file4.mkdirs()) {
                String string = OStrings.getString("CT_ERROR_CREATE") + "\n(.../glos/)";
                throw new IOException(string);
            }
            File file5 = new File(this.m_config.getTMRoot());
            if (!file5.isDirectory() && !file5.mkdirs()) {
                String string = OStrings.getString("CT_ERROR_CREATE") + "\n(.../tm/)";
                throw new IOException(string);
            }
            File file6 = new File(this.m_config.getTargetRoot());
            if (!file6.isDirectory() && !file6.mkdirs()) {
                String string = OStrings.getString("CT_ERROR_CREATE") + "\n(.../target/)";
                throw new IOException(string);
            }
            this.m_config.buildProjFile();
        }
        catch (IOException iOException) {
            String string = OStrings.getString("CT_ERROR_CREATING_PROJECT");
            this.displayError(string, iOException);
        }
    }

    private void loadTranslations() {
        File file;
        try {
            file = new File(this.m_config.getProjectInternal() + "project_save.tmx");
            if (!file.exists()) {
                Log.logErrorRB("CT_ERROR_CANNOT_FIND_TMX", new Object[]{file});
                return;
            }
        }
        catch (SecurityException securityException) {
            String string = OStrings.getString("CT_ERROR_ACCESS_PROJECT_FILE");
            this.displayError(string, securityException);
            return;
        }
        try {
            this.m_transFrame.setMessageText(OStrings.getString("CT_LOAD_TMX"));
            this.loadTMXFile(file.getAbsolutePath(), "UTF-8", true);
        }
        catch (IOException iOException) {
            String string = OStrings.getString("CT_ERROR_LOADING_PROJECT_FILE");
            this.displayError(string, iOException);
        }
    }

    private boolean loadProject(String string) throws IOException, InterruptedIOException, TranslationException {
        if (!this.m_config.loadExisting(this.m_transFrame, string)) {
            return false;
        }
        StaticUtils.clearTokenCache();
        this.projectClosing = false;
        this.m_glossary = new GlossaryManager();
        this.m_glossary.loadGlossaryFiles(new File(this.m_config.getGlossaryRoot()));
        FilterMaster filterMaster = FilterMaster.getInstance();
        ArrayList arrayList = new ArrayList();
        File file = new File(this.m_config.getSourceRoot());
        StaticUtils.buildFileList(arrayList, file, true);
        HashSet hashSet = new HashSet();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            File file2 = new File(string2);
            if (hashSet.contains(file2)) continue;
            String string3 = string2.substring(this.m_config.getSourceRoot().length());
            this.m_transFrame.setMessageText(StaticUtils.format(OStrings.getString("CT_LOAD_FILE_MX"), new Object[]{string3}));
            this.m_curFile = new ProjectFileData();
            this.m_curFile.name = string2;
            this.m_curFile.firstEntry = this.m_srcTextEntryArray.size();
            boolean bl = filterMaster.loadFile(string2, hashSet);
            this.m_curFile.lastEntry = this.m_srcTextEntryArray.size() - 1;
            if (!bl || this.m_curFile.lastEntry < this.m_curFile.firstEntry) continue;
            this.m_projWin.addFile(string3, this.numEntries());
        }
        this.m_transFrame.setMessageText(OStrings.getString("CT_LOAD_SRC_COMPLETE"));
        this.m_curFile = null;
        this.loadTranslations();
        this.m_projWin.setVisible(true);
        this.m_projWin.toFront();
        m_spellchecker.initialize();
        return true;
    }

    private void buildNearList() throws InterruptedException {
        FuzzyMatcher fuzzyMatcher = new FuzzyMatcher(this.m_transFrame, this);
        fuzzyMatcher.match(this.m_strEntryList);
        for (int i = 0; i < this.m_legacyTMs.size(); ++i) {
            LegacyTM legacyTM = (LegacyTM)this.m_legacyTMs.get(i);
            fuzzyMatcher.match(this.m_strEntryList, legacyTM.getName(), legacyTM.getStrings());
        }
    }

    private void loadTM() throws IOException {
        ArrayList arrayList = new ArrayList(this.m_strEntryList.size());
        arrayList.clear();
        File file = new File(this.m_config.getTMRoot());
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.clear();
            String string = stringArray[i];
            int n = string.lastIndexOf(46);
            if (n < 0) {
                n = string.length();
            }
            String string2 = string.substring(n);
            string = this.m_config.getTMRoot();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string = string + stringArray[i];
            if (string2.equalsIgnoreCase(".tmx")) {
                this.loadTMXFile(string, "UTF-8", false);
                continue;
            }
            if (!string2.equalsIgnoreCase(".wf")) continue;
            this.loadTMXFile(string, "ISO-8859-1", false);
        }
    }

    private void loadTMXFile(String string, String string2, boolean bl) throws IOException {
        Object object;
        TMXReader tMXReader = new TMXReader(string2, this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage());
        LFileCopy.copy(string, string + ".tmp");
        tMXReader.loadFile(string + ".tmp", bl);
        new File(string + ".tmp").delete();
        int n = tMXReader.numSegments();
        ArrayList<StringEntry> arrayList = new ArrayList<StringEntry>(n);
        ArrayList<StringEntry> arrayList2 = null;
        if (bl) {
            object = new File(string);
            long l = ((File)object).lastModified();
            if (l == 0L) {
                l = new Date().getTime();
            }
            LFileCopy.copy(string, string + "." + this.millisToDateTime(l) + ".bak");
            this.removeOldBackups((File)object);
        }
        if (bl) {
            arrayList2 = new ArrayList<StringEntry>();
            object = new LegacyTM(OStrings.getString("CT_ORPHAN_STRINGS"), arrayList2);
            this.m_legacyTMs.add(object);
        } else {
            object = new LegacyTM(new File(string).getName(), arrayList);
            this.m_legacyTMs.add(object);
        }
        for (int i = 0; i < n; ++i) {
            StringEntry stringEntry;
            String string3 = tMXReader.getSourceSegment(i);
            String string4 = tMXReader.getTargetSegment(i);
            if (bl) {
                stringEntry = (StringEntry)this.m_strEntryHash.get(string3);
                if (stringEntry == null) {
                    TransMemory transMemory = new TransMemory(string3, string4, string);
                    this.m_orphanedList.add(transMemory);
                    this.m_tmList.add(transMemory);
                    stringEntry = new StringEntry(string3);
                    this.dontCountNextIncrement();
                    stringEntry.setTranslation(string4);
                    arrayList2.add(stringEntry);
                    continue;
                }
                stringEntry.setTranslation(string4);
                continue;
            }
            this.m_tmList.add(new TransMemory(string3, string4, string));
            stringEntry = new StringEntry(string3);
            this.dontCountNextIncrement();
            stringEntry.setTranslation(string4);
            arrayList.add(stringEntry);
        }
    }

    private String millisToDateTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        return this.pad2(n) + this.pad2(n2) + this.pad2(n3) + this.pad2(n4) + this.pad2(n5);
    }

    private String pad2(int n) {
        if (n < 10) {
            return "0" + Integer.toString(n);
        }
        return Integer.toString(n);
    }

    private void removeOldBackups(File file) {
        try {
            File file2 = file.getParentFile();
            List<File> list = Arrays.asList(file2.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".bak");
                }
            }));
            if (list.size() > 10) {
                Collections.sort(list, new Comparator(){

                    public int compare(Object object, Object object2) {
                        File file = (File)object;
                        File file2 = (File)object2;
                        if (file.lastModified() == file2.lastModified()) {
                            return 0;
                        }
                        if (file.lastModified() > file2.lastModified()) {
                            return -1;
                        }
                        return 1;
                    }
                });
                for (int i = 10; i < list.size(); ++i) {
                    list.get(i).delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void displayError(String string, Throwable throwable) {
        Log.logRB("LD_ERROR", new Object[]{string});
        Log.log(throwable);
        Log.log("----------------------------");
        if (this.m_transFrame != null) {
            MessageRelay.uiMessageDisplayError(this.m_transFrame, string, throwable);
        }
    }

    public void displayErrorMessage(String string, Throwable throwable) {
        if (this.m_transFrame != null) {
            this.m_transFrame.displayError(string, throwable);
        }
    }

    private int numberOfWords(String string) {
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        int n2 = 0;
        BreakIterator breakIterator = StaticUtils.getWordBreaker();
        breakIterator.setText(string);
        String string2 = new String();
        int n3 = breakIterator.first();
        int n4 = breakIterator.next();
        while (n4 != -1) {
            String string3 = string2;
            string2 = string.substring(n3, n4);
            boolean bl = false;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (!Character.isLetterOrDigit(c)) continue;
                bl = true;
                break;
            }
            if (bl && !PatternConsts.OMEGAT_TAG.matcher(string2).matches()) {
                ++n2;
            }
            n3 = n4;
            n4 = breakIterator.next();
        }
        return n2;
    }

    private int numberOfCharactersWithoutSpaces(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isSpaceChar(string.charAt(i))) continue;
            ++n;
        }
        return n;
    }

    private void buildProjectStats() {
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 1;
        int n6 = 2;
        int n7 = 3;
        int n8 = 4;
        int n9 = 5;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        for (n3 = 0; n3 < this.m_strEntryList.size(); ++n3) {
            StringEntry stringEntry = (StringEntry)this.m_strEntryList.get(n3);
            String string = stringEntry.getSrcText();
            n2 = stringEntry.getParentList().size();
            int n20 = this.numberOfWords(string);
            n11 += n20;
            n10 += n20 * n2;
            n = this.numberOfCharactersWithoutSpaces(string);
            n13 += n;
            n12 += n * n2;
            int n21 = string.length();
            n15 += n21;
            n14 += n21 * n2;
            if (stringEntry.isTranslated()) continue;
            n16 += n20;
            n17 += n;
            n18 += n21;
            n19 += n2;
        }
        n3 = this.getNumberOfUniqueSegments() - this.getNumberofTranslatedSegments();
        int n22 = 0;
        int n23 = 0;
        n2 = 0;
        TreeMap<String, int[]> treeMap = new TreeMap<String, int[]>();
        for (n = 0; n < this.m_srcTextEntryArray.size(); ++n) {
            SourceTextEntry sourceTextEntry = (SourceTextEntry)this.m_srcTextEntryArray.get(n);
            object3 = sourceTextEntry.getSrcFile().name;
            object2 = treeMap.containsKey(object3 = StaticUtils.makeFilenameRelative((String)object3, this.getProjectProperties().getSourceRoot())) ? (int[])treeMap.get(object3) : new int[]{0, 0, 0, 0, 0, 0};
            object = sourceTextEntry.getSrcText();
            int n24 = this.numberOfWords((String)object);
            int n25 = n4;
            object2[n25] = object2[n25] + n24;
            int n26 = this.numberOfCharactersWithoutSpaces((String)object);
            int n27 = n6;
            object2[n27] = object2[n27] + n26;
            int n28 = ((String)object).length();
            int n29 = n8;
            object2[n29] = object2[n29] + n28;
            if (!sourceTextEntry.isTranslated()) {
                n22 += n24;
                int n30 = n5;
                object2[n30] = object2[n30] + n24;
                n23 += n26;
                int n31 = n7;
                object2[n31] = object2[n31] + n26;
                n2 += n28;
                int n32 = n9;
                object2[n32] = object2[n32] + n28;
            }
            treeMap.put((String)object3, (int[])object2);
        }
        try {
            Object object4;
            try {
                object4 = new File(this.m_config.getProjectInternal() + "word_counts");
                if (((File)object4).exists()) {
                    ((File)object4).delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object4 = this.m_config.getProjectInternal() + "project_stats.txt";
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((String)object4), "UTF-8");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Project_Statistics") + "\n\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Total") + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Segments") + "\t" + this.getNumberOfSegmentsTotal() + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Words") + "\t" + n10 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters_NOSP") + "\t" + n12 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters") + "\t" + n14 + "\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Remaining") + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Segments") + "\t" + n19 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Words") + "\t" + n22 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters_NOSP") + "\t" + n23 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters") + "\t" + n2 + "\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Unique") + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Segments") + "\t" + this.getNumberOfUniqueSegments() + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Words") + "\t" + n11 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters_NOSP") + "\t" + n13 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters") + "\t" + n15 + "\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_Unique_Remaining") + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Segments") + "\t" + n3 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Words") + "\t" + n16 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters_NOSP") + "\t" + n17 + "\n");
            outputStreamWriter.write("\t" + OStrings.getString("CT_STATS_Characters") + "\t" + n18 + "\n");
            outputStreamWriter.write("\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_FILE_Statistics") + "\n\n");
            outputStreamWriter.write(OStrings.getString("CT_STATS_FILE_Name") + "\t" + OStrings.getString("CT_STATS_FILE_Total_Words") + "\t" + OStrings.getString("CT_STATS_FILE_Remaining_Words") + "\t" + OStrings.getString("CT_STATS_FILE_Total_Characters_NOSP") + "\t" + OStrings.getString("CT_STATS_FILE_Remaining_Characters_NOSP") + "\t" + OStrings.getString("CT_STATS_FILE_Total_Characters") + "\t" + OStrings.getString("CT_STATS_FILE_Remaining_Characters") + "\n");
            object3 = treeMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (int[])treeMap.get(object2);
                outputStreamWriter.write((String)object2 + "\t" + (int)object[n4] + "\t" + (int)object[n5] + "\t" + (int)object[n6] + "\t" + (int)object[n7] + "\t" + (int)object[n8] + "\t" + (int)object[n9] + "\n");
            }
            ((Writer)outputStreamWriter).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SourceTextEntry getSTE(int n) {
        try {
            return (SourceTextEntry)this.m_srcTextEntryArray.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            StringEntry stringEntry = new StringEntry(OStrings.getString("TF_INTRO_EMPTYPROJECT"));
            stringEntry.setTranslation(" ");
            ProjectFileData projectFileData = new ProjectFileData();
            projectFileData.name = this.sourceRoot() + OStrings.getString("TF_INTRO_EMPTYPROJECT_FILENAME");
            projectFileData.firstEntry = 0;
            projectFileData.lastEntry = 0;
            return new SourceTextEntry(stringEntry, projectFileData, 0);
        }
    }

    public StringEntry getStringEntry(String string) {
        return (StringEntry)this.m_strEntryHash.get(string);
    }

    public String sourceRoot() {
        return this.m_config.getSourceRoot();
    }

    public int numEntries() {
        return this.m_srcTextEntryArray.size();
    }

    public MainWindow getTransFrame() {
        return this.m_transFrame;
    }

    public ArrayList getTransMemory() {
        return this.m_tmList;
    }

    public ProjectProperties getProjectProperties() {
        return this.m_config;
    }

    public synchronized boolean isProjectModified() {
        return this.m_modifiedFlag;
    }

    public int getNumberOfSegmentsTotal() {
        return this.m_srcTextEntryArray.size();
    }

    public int getNumberOfUniqueSegments() {
        return this.m_strEntryList.size();
    }

    public synchronized int getNumberofTranslatedSegments() {
        return this.numberofTranslatedSegments;
    }

    public synchronized void decreaseTranslated() {
        --this.numberofTranslatedSegments;
        this.uiUpdateNumberOfTranslatedSegments();
    }

    public synchronized void dontCountNextIncrement() {
        this._dontCountNext = true;
    }

    public synchronized void increaseTranslated() {
        if (this._dontCountNext) {
            this._dontCountNext = false;
        } else {
            ++this.numberofTranslatedSegments;
            this.uiUpdateNumberOfTranslatedSegments();
        }
    }

    private void uiUpdateNumberOfTranslatedSegments() {
        if (this.m_projWin == null || !this.m_projWin.isVisible()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                CommandThread.this.m_projWin.updateNumberOfTranslatedSegments();
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    static {
        m_spellchecker = SpellChecker.getInstance();
    }
}

