/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.tmx.util.task;

import java.io.File;
import java.io.IOException;
import java.util.Collections;

import blanco.commons.util.BlancoStringUtil;
import blanco.tmx.BlancoTmxParser;
import blanco.tmx.BlancoTmxSerializer;
import blanco.tmx.util.message.BlancoTmxUtilMessage;
import blanco.tmx.util.task.valueobject.BlancoTmxUtilConvertProcessInput;
import blanco.tmx.valueobject.BlancoTmx;
import blanco.tmx.valueobject.BlancoTmxTu;
import blanco.tmx.valueobject.BlancoTmxTuv;

public class BlancoTmxUtilConvertProcessImpl implements
        BlancoTmxUtilConvertProcess {
    private final BlancoTmxUtilMessage fMsg = new BlancoTmxUtilMessage();

    private BlancoTmxUtilConvertProcessInput fInput = null;

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     * 
     * @param input
     *            ̓̓p[^B
     * @return ̎sʁB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int execute(final BlancoTmxUtilConvertProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File sourceDir = new File(input.getSourcedir());

        final File targetDir = new File(input.getTargetdir());

        // ̓fBNg̑݃`FbNB
        if (sourceDir.exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbtmut01(sourceDir
                    .getAbsolutePath()));
        }
        if (sourceDir.isDirectory() == false) {
            throw new IllegalArgumentException(fMsg.getMbtmut02(sourceDir
                    .getAbsolutePath()));
        }
        if (targetDir.exists() == false) {
            if (targetDir.mkdirs() == false) {
                throw new IllegalArgumentException(fMsg.getMbtmut03(targetDir
                        .getAbsolutePath()));
            }
        }
        if (targetDir.isDirectory() == false) {
            throw new IllegalArgumentException(fMsg.getMbtmut04(targetDir
                    .getAbsolutePath()));
        }
        if (sourceDir.getCanonicalPath().equals(targetDir.getCanonicalPath())) {
            throw new IllegalArgumentException(fMsg.getMbtmut05(sourceDir
                    .getAbsolutePath(), targetDir.getAbsolutePath()));
        }

        final File[] files = sourceDir.listFiles();
        if (files == null) {
            return 0;
        }
        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                continue;
            }
            if (files[index].getName().endsWith(".tmx")) {
                process(files[index], targetDir);
            }
        }

        return 0;
    }

    private void process(final File sourceFile, final File targetDir)
            throws IOException {

        final BlancoTmxParser parser = new BlancoTmxParser();
        final BlancoTmx tmx = parser.parse(sourceFile);

        // GR[fBO㏑B
        if (BlancoStringUtil.null2Blank(fInput.getEncoding()).length() > 0) {
            tmx.setEncoding(fInput.getEncoding());
        }

        processTmx(tmx);

        final BlancoTmxSerializer serializer = new BlancoTmxSerializer();
        serializer.setIndent(fInput.getIsindentxml());
        serializer.serialize(tmx, new File(targetDir.getAbsolutePath() + "/"
                + sourceFile.getName()));
    }

    private void processTmx(final BlancoTmx tmx) {
        for (BlancoTmxTu tu : tmx.getBody().getTuList()) {
            for (BlancoTmxTuv tuv : tu.getTuvList()) {
                if (fInput.getAdjustlang()) {
                    if ("en_US".equals(tuv.getLang())) {
                        tuv.setLang("EN-US");
                    }
                    if ("ja_JP".equals(tuv.getLang())) {
                        tuv.setLang("JA");
                    }
                }
            }
        }

        // \[g
        switch (fInput.getSortorder()) {
        case 1:
            Collections.sort(tmx.getBody().getTuList(), new TuSegComparator());
            break;
        }
    }

    /**
     * tu ̃[Ŕr܂B
     */
    class TuSegComparator implements java.util.Comparator<BlancoTmxTu> {
        public int compare(final BlancoTmxTu tu1, final BlancoTmxTu tu2) {
            // seg Ń\[gB
            if (Math.max(tu1.getTuvList().size(), tu2.getTuvList().size()) == 0) {
                return 0;
            }
            if (Math.min(tu1.getTuvList().size(), tu2.getTuvList().size()) == 0) {
                return tu1.getTuvList().size() - tu2.getTuvList().size();
            }
            // ŏ tuv  seg Ń\[g܂B
            // ӁBlang Ń\[gĂȂ_ɒӁB
            final int sortBySeg = tu1.getTuvList().get(0).getSeg().compareTo(
                    tu2.getTuvList().get(0).getSeg());
            if (sortBySeg != 0) {
                return sortBySeg;
            }

            // tuid Ń\[gB
            if (Math.max(tu1.getTuid().length(), tu2.getTuid().length()) == 0) {
                return 0;
            }
            if (Math.min(tu1.getTuid().length(), tu2.getTuid().length()) == 0) {
                return tu1.getTuid().length() - tu2.getTuid().length();
            }
            return tu1.getTuid().compareTo(tu2.getTuid());
        }
    }
}
