/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.pleiades.util.task;

import java.io.IOException;

import blanco.pleiades.util.task.valueobject.BlancoPleiadesUtilTranslationNotfound2XliffProcessInput;

/**
 * ob`NX [BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.pleiades.util.task.BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess -help
 * </code>
 */
public class BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess batchProcess = new BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess();

        // ob`̈B
        final BlancoPleiadesUtilTranslationNotfound2XliffProcessInput input = new BlancoPleiadesUtilTranslationNotfound2XliffProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldSourcefileProcessed = false;
        boolean isFieldXliffdirProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourcefile=")) {
                input.setSourcefile(arg.substring(12));
                isFieldSourcefileProcessed = true;
            } else if (arg.startsWith("-xliffdir=")) {
                input.setXliffdir(arg.substring(10));
                isFieldXliffdirProcessed = true;
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldSourcefileProcessed == false) {
            System.out.println("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcefile]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldXliffdirProcessed == false) {
            System.out.println("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[xliffdir]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoPleiadesUtilTranslationNotfound2XliffProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoPleiadesUtilTranslationNotfound2XliffProcessC^tF[X blanco.pleiades.util.taskpbP[W BlancoPleiadesUtilTranslationNotfound2XliffProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoPleiadesUtilTranslationNotfound2XliffProcess process = new BlancoPleiadesUtilTranslationNotfound2XliffProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoPleiadesUtilTranslationNotfound2XliffProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: Usage:");
        System.out.println("  java blanco.pleiades.util.task.BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess -verbose=l1 -sourcefile=l2 -xliffdir=l3");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourcefile");
        System.out.println("      [͌ƂȂPleiades translation-notfound.properties t@CB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -xliffdir");
        System.out.println("      [o͐ƂȂXLIFFfBNgB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoPleiadesUtilTranslationNotfound2XliffProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getSourcefile() == null) {
            throw new IllegalArgumentException("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcefile]ɒlݒ肳Ă܂B");
        }
        if (input.getXliffdir() == null) {
            throw new IllegalArgumentException("BlancoPleiadesUtilTranslationNotfound2XliffBatchProcess: JnsB̓p[^[input]̕K{tB[hl[xliffdir]ɒlݒ肳Ă܂B");
        }
    }
}
