/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.report.task;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.pdf.page.valueobject.BlancoPdfBlockDef;
import blanco.pdf.page.valueobject.BlancoPdfItemDef;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.report.task.valueobject.BlancoPdfReportProcessInput;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

class BlancoPdfReportGenerateValueObject {
    BlancoPdfReportProcessInput fInput = null;

    BlancoPdfReportGenerateValueObject(final BlancoPdfReportProcessInput input) {
        fInput = input;
    }

    /**
     * ItemBean \[XR[h𐶐B
     * 
     * @param pageDef
     * @throws IOException
     */
    void generateItemBean(final BlancoPdfPageDef pageDef) throws IOException {
        {
            // {
            final BlancoValueObjectClassStructure classStructure = new BlancoValueObjectClassStructure();
            classStructure.setPackage(pageDef.getPackage() + ".items");
            classStructure.setName(BlancoNameAdjuster.toClassName(pageDef
                    .getName())
                    + "PdfReportItems");
            classStructure.setDescription("PDF ڌQB");

            if (hasLayer(pageDef.getItemList())) {
                // C[óB
                final BlancoValueObjectFieldStructure field = new BlancoValueObjectFieldStructure();
                classStructure.getFieldList().add(field);
                field.setName("Layer");
                field.setType("int");
                field.setDefault("0");
                field.setDescription("PDF o͂̂߂̓ǗC[B");
            }

            for (BlancoPdfItemDef itemDef : pageDef.getItemList()) {
                generateItemBeanInternal(itemDef, classStructure);
            }

            for (BlancoPdfBlockDef blockDef : pageDef.getBlockList()) {
                // ubNp[^ƂĕێB
                final BlancoValueObjectFieldStructure field = new BlancoValueObjectFieldStructure();
                classStructure.getFieldList().add(field);
                field.setName(BlancoNameAdjuster
                        .toClassName(blockDef.getName())
                        + "List");
                field.setType("java.util.List<" + pageDef.getPackage()
                        + ".items."
                        + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReport"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "Items" + ">");
                field.setDefault("new java.util.ArrayList<"
                        + pageDef.getPackage() + ".items."
                        + BlancoNameAdjuster.toClassName(pageDef.getName())
                        + "PdfReport"
                        + BlancoNameAdjuster.toClassName(blockDef.getName())
                        + "Items" + ">()");
            }

            final BlancoValueObjectXml2JavaClass java2Class = new BlancoValueObjectXml2JavaClass();
            java2Class.setEncoding(fInput.getEncoding());
            java2Class.structure2Source(classStructure, new File(fInput
                    .getTargetdir()));
        }
        for (BlancoPdfBlockDef blockDef : pageDef.getBlockList()) {
            // ubN
            final BlancoValueObjectClassStructure classStructure = new BlancoValueObjectClassStructure();
            classStructure.setPackage(pageDef.getPackage() + ".items");
            classStructure.setName(BlancoNameAdjuster.toClassName(pageDef
                    .getName())
                    + "PdfReport"
                    + BlancoNameAdjuster.toClassName(blockDef.getName())
                    + "Items");
            classStructure.setDescription("PDF ڌQB");

            if (hasLayer(blockDef.getItemList())) {
                // C[óB
                final BlancoValueObjectFieldStructure field = new BlancoValueObjectFieldStructure();
                classStructure.getFieldList().add(field);
                field.setName("Layer");
                field.setType("int");
                field.setDefault("0");
                field.setDescription("PDF o͂̂߂̓ǗC[B");
            }

            for (BlancoPdfItemDef itemDef : blockDef.getItemList()) {
                generateItemBeanInternal(itemDef, classStructure);
            }

            final BlancoValueObjectXml2JavaClass java2Class = new BlancoValueObjectXml2JavaClass();
            java2Class.setEncoding(fInput.getEncoding());
            java2Class.structure2Source(classStructure, new File(fInput
                    .getTargetdir()));
        }
    }

    void generateItemBeanInternal(final BlancoPdfItemDef itemDef,
            final BlancoValueObjectClassStructure classStructure)
            throws IOException {
        final BlancoValueObjectFieldStructure field = new BlancoValueObjectFieldStructure();
        field.setName(BlancoNameAdjuster.toClassName(itemDef.getName()));
        if ("decimal".equals(itemDef.getType())) {
            field.setType("java.math.BigDecimal");
        } else {
            field.setType("java.lang.String");
        }
        classStructure.getFieldList().add(field);
    }

    public static boolean hasLayer(final List<BlancoPdfItemDef> itemsList) {
        for (BlancoPdfItemDef items : itemsList) {
            if (items.getLayer() != 0) {
                return true;
            }
        }

        return false;
    }
}
