/*
 * ̃\[XR[h blanco Frameworkɂ莩܂B
 */
package blanco.pdf.valueobject;

import java.awt.Color;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * PDF gNXEo[IuWFNgB
 */
@XmlRootElement
public class BlancoPdfMetrix {
    /**
     * eLXgFB
     *
     * tB[h: [colorText]B
     */
    private Color fColorText;

    /**
     * Xg[NFB
     *
     * tB[h: [colorStroke]B
     */
    private Color fColorStroke;

    /**
     * hԂFB
     *
     * tB[h: [colorFill]B
     */
    private Color fColorFill;

    /**
     * s̕B
     *
     * tB[h: [lineWidth]B
     * ftHg: [0.1f]B
     */
    private float fLineWidth = 0.1f;

    /**
     * _ȂǁB
     *
     * tB[h: [lineDash]B
     */
    private float[] fLineDash;

    /**
     * tHgB
     *
     * tB[h: [font]B
     * ftHg: ["gothic"]B
     */
    private String fFont = "gothic";

    /**
     * tHgTCYB
     *
     * tB[h: [fontSize]B
     * ftHg: [12]B
     */
    private int fFontSize = 12;

    /**
     * tB[h [colorText] ̒lݒ肵܂B
     *
     * tB[h̐: [eLXgFB]B
     *
     * @param argColorText tB[h[colorText]ɐݒ肷lB
     */
    public void setColorText(final Color argColorText) {
        fColorText = argColorText;
    }

    /**
     * tB[h [colorText] ̒l擾܂B
     *
     * tB[h̐: [eLXgFB]B
     *
     * @return tB[h[colorText]擾lB
     */
    public Color getColorText() {
        return fColorText;
    }

    /**
     * tB[h [colorStroke] ̒lݒ肵܂B
     *
     * tB[h̐: [Xg[NFB]B
     *
     * @param argColorStroke tB[h[colorStroke]ɐݒ肷lB
     */
    public void setColorStroke(final Color argColorStroke) {
        fColorStroke = argColorStroke;
    }

    /**
     * tB[h [colorStroke] ̒l擾܂B
     *
     * tB[h̐: [Xg[NFB]B
     *
     * @return tB[h[colorStroke]擾lB
     */
    public Color getColorStroke() {
        return fColorStroke;
    }

    /**
     * tB[h [colorFill] ̒lݒ肵܂B
     *
     * tB[h̐: [hԂFB]B
     *
     * @param argColorFill tB[h[colorFill]ɐݒ肷lB
     */
    public void setColorFill(final Color argColorFill) {
        fColorFill = argColorFill;
    }

    /**
     * tB[h [colorFill] ̒l擾܂B
     *
     * tB[h̐: [hԂFB]B
     *
     * @return tB[h[colorFill]擾lB
     */
    public Color getColorFill() {
        return fColorFill;
    }

    /**
     * tB[h [lineWidth] ̒lݒ肵܂B
     *
     * tB[h̐: [s̕B]B
     *
     * @param argLineWidth tB[h[lineWidth]ɐݒ肷lB
     */
    public void setLineWidth(final float argLineWidth) {
        fLineWidth = argLineWidth;
    }

    /**
     * tB[h [lineWidth] ̒l擾܂B
     *
     * tB[h̐: [s̕B]B
     * ftHg: [0.1f]B
     *
     * @return tB[h[lineWidth]擾lB
     */
    public float getLineWidth() {
        return fLineWidth;
    }

    /**
     * tB[h [lineDash] ̒lݒ肵܂B
     *
     * tB[h̐: [_ȂǁB]B
     *
     * @param argLineDash tB[h[lineDash]ɐݒ肷lB
     */
    public void setLineDash(final float[] argLineDash) {
        fLineDash = argLineDash;
    }

    /**
     * tB[h [lineDash] ̒l擾܂B
     *
     * tB[h̐: [_ȂǁB]B
     *
     * @return tB[h[lineDash]擾lB
     */
    public float[] getLineDash() {
        return fLineDash;
    }

    /**
     * tB[h [font] ̒lݒ肵܂B
     *
     * tB[h̐: [tHgB]B
     *
     * @param argFont tB[h[font]ɐݒ肷lB
     */
    public void setFont(final String argFont) {
        fFont = argFont;
    }

    /**
     * tB[h [font] ̒l擾܂B
     *
     * tB[h̐: [tHgB]B
     * ftHg: ["gothic"]B
     *
     * @return tB[h[font]擾lB
     */
    public String getFont() {
        return fFont;
    }

    /**
     * tB[h [fontSize] ̒lݒ肵܂B
     *
     * tB[h̐: [tHgTCYB]B
     *
     * @param argFontSize tB[h[fontSize]ɐݒ肷lB
     */
    public void setFontSize(final int argFontSize) {
        fFontSize = argFontSize;
    }

    /**
     * tB[h [fontSize] ̒l擾܂B
     *
     * tB[h̐: [tHgTCYB]B
     * ftHg: [12]B
     *
     * @return tB[h[fontSize]擾lB
     */
    public int getFontSize() {
        return fFontSize;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.pdf.valueobject.BlancoPdfMetrix[");
        buf.append("colorText=" + fColorText);
        buf.append(",colorStroke=" + fColorStroke);
        buf.append(",colorFill=" + fColorFill);
        buf.append(",lineWidth=" + fLineWidth);
        if (fLineDash == null) {
            buf.append(",lineDash=null");
        } else {
            buf.append(",lineDash=[");
            for (int index = 0; index < fLineDash.length; index++) {
                buf.append((index == 0 ? "" : ", ") + fLineDash[index]);
            }
            buf.append("]");
        }
        buf.append(",font=" + fFont);
        buf.append(",fontSize=" + fFontSize);
        buf.append("]");
        return buf.toString();
    }
}
