/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;

import junit.framework.TestCase;
import blanco.pdf.font.BlancoPdfFontUtil;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.valueobject.BlancoPdfMetrix;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;

public class BlancoPdfWriterTest extends TestCase {

    public void testBlancoPdfWriter() throws Exception {
        new File("tmp").mkdirs();

        final BlancoPdfPageDef pageDef = new BlancoPdfPageDef();

        final BlancoPdfWriter writer = new BlancoPdfWriter(pageDef,
                new FileOutputStream("tmp/abc.pdf"));
        writer.getPdfSetting().setConfPath("conf/pdf");

        final BaseFont bf = BlancoPdfFontUtil.getFont(writer.getPdfSetting(),
                "gothic");

        final BlancoPdfMetrix metrix = new BlancoPdfMetrix();

        metrix.setColorText(Color.RED);
        writer.drawText(PdfContentByte.ALIGN_LEFT, 30, 30, "", bf, 30,
                metrix);
        metrix.setLineDash(new float[] { 3, 3 });
        metrix.setColorStroke(Color.YELLOW);
        writer.drawLine(30, 30, 50, 50, metrix);

        writer.newPage();
        writer.drawText(PdfContentByte.ALIGN_LEFT, 30, 30, "", bf, 30,
                metrix);

        writer.close();
    }

    public void testBlancoPdfWriterBinding() throws Exception {
        final BlancoPdfPageDef pageDef = new BlancoPdfPageDef();

        final BlancoPdfWriter writer = new BlancoPdfWriter(pageDef,
                new FileOutputStream("tmp/bind.pdf"));
        writer.getPdfSetting().setConfPath("conf/pdf");

        final BlancoPdfWriter writer02 = new BlancoPdfWriter(pageDef, writer);
        writer02.getPdfSetting().setConfPath("conf/pdf");

        final BlancoPdfMetrix metrix = new BlancoPdfMetrix();

        final BaseFont bf = BlancoPdfFontUtil.getFont(writer.getPdfSetting(),
                "gothic");

        writer.drawText(PdfContentByte.ALIGN_LEFT, 30, 30, "", bf, 30,
                metrix);

        metrix.setColorText(Color.RED);
        writer.drawCircle(20, 20, 10, metrix);

        writer02.drawText(PdfContentByte.ALIGN_LEFT, 70, 30, "", bf, 30,
                metrix);

        writer02.newPage();

        writer02.close();
        writer.close();
    }
}
