/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.page;

import java.io.File;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import junit.framework.TestCase;
import blanco.pdf.form.valueobject.BlancoPdfFormLineDef;
import blanco.pdf.form.valueobject.BlancoPdfFormTextDef;
import blanco.pdf.page.task.BlancoPdfPageDefCheckerProcessImpl;
import blanco.pdf.page.task.valueobject.BlancoPdfPageDefCheckerProcessInput;
import blanco.pdf.page.valueobject.BlancoPdfBlockDef;
import blanco.pdf.page.valueobject.BlancoPdfItemDef;
import blanco.pdf.page.valueobject.BlancoPdfKeyBreakDef;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;

public class BlancoPdfPageUtilTest extends TestCase {
    public void testTate() throws Exception {
        final BlancoPdfPageDefCheckerProcessInput input = new BlancoPdfPageDefCheckerProcessInput();
        input.setConfdir("./conf/pdf");
        input.setVerbose(true);
        new BlancoPdfPageDefCheckerProcessImpl().execute(input);
    }

    public void testAAA() throws Exception {
        new File("tmp").mkdirs();

        final BlancoPdfPageDef page = new BlancoPdfPageDef();
        final BlancoPdfItemDef item = new BlancoPdfItemDef();
        item.setName("aaa");
        page.getItemList().add(item);

        {
            final BlancoPdfBlockDef block = new BlancoPdfBlockDef();
            page.getBlockList().add(block);
            block.setX(1);
            block.setY(1);
            block.setPitchX(1);
            block.setPitchY(1);
            block.setMaxOccurs(3);
            block.getItemList().add(item);
            {
                final BlancoPdfKeyBreakDef keyBreakDef = new BlancoPdfKeyBreakDef();
                item.getKeyBreakAfterList().add(keyBreakDef);
                keyBreakDef.setDupLayerTarget(1);
            }
        }

        {
            final BlancoPdfFormTextDef text = new BlancoPdfFormTextDef();
            page.getForm().getTextList().add(text);
            final BlancoPdfFormLineDef line = new BlancoPdfFormLineDef();
            page.getForm().getLineList().add(line);
        }

        final JAXBContext context = JAXBContext
                .newInstance(BlancoPdfPageDef.class);
        final Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(page, new File("tmp/aaa.xml"));
    }
}
