package blanco.pdf.page;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import junit.framework.TestCase;
import blanco.pdf.page.valueobject.BlancoPdfPageDef;
import blanco.pdf.valueobject.BlancoPdfSetting;

public class BlancoPdfPageWriterTest extends TestCase {
    public void testAAA() throws Exception {
        BlancoPdfSetting setting = new BlancoPdfSetting();
        setting.setConfPath("./conf/pdf");
        final BlancoPdfPageDef pageDef01 = BlancoPdfPageUtil.read(setting,
                "yoko01");
        final BlancoPdfPageDef pageDef02 = BlancoPdfPageUtil.read(setting,
                "yoko02");

        final File dir = new File("./tmp/pdf/BlancoPdfPageWriterTest");
        dir.mkdirs();
        final OutputStream outStream = new BufferedOutputStream(
                new FileOutputStream(new File(dir, "aaa.pdf")));
        final BlancoPdfPageWriter writer = new BlancoPdfPageWriter(setting
                .getConfPath(), pageDef01, outStream);

        final BlancoPdfPageWriter writer02 = new BlancoPdfPageWriter(setting
                .getConfPath(), pageDef01, writer.getBlancoPdfWriter());

        writer.drawForm();

        writer02.nextPage();

        writer.close();

        outStream.flush();
        outStream.close();
    }
}
