/*
 * Decompiled with CFR 0.152.
 */
package hayashi.yuu.register;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeviceData {
    String deviceID = null;
    String deviceName = null;
    String typeID = null;
    String typeName = "GuardiX OEM";
    public int status;
    String verAVR = null;
    Date dateAVR = null;
    String verMSP = null;
    String verType = null;

    public String getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(String statusStr) {
        this.status = Integer.parseInt(statusStr, 16);
    }

    public String getStatusName() {
        if (this.status == 2) {
            return "\u6b63\u5e38";
        }
        StringBuffer sbuf = new StringBuffer();
        if ((this.status & 2) == 0) {
            sbuf.append("\u6b8b\u30c7\u30fc\u30bf\u3042\u308a ");
        } else {
            sbuf.append("\u6b8b\u30c7\u30fc\u30bf\u306a\u3057 ");
        }
        sbuf.append("[");
        if ((this.status & 1) != 0) {
            sbuf.append("\uff32\uff21\uff2d\u30a8\u30e9\u30fc\u767a\u751f! , ");
        }
        if ((this.status & 4) != 0) {
            sbuf.append("\u8981\u30d0\u30c3\u30c6\u30ea\u30fc\u4ea4\u63db! , ");
        }
        if ((this.status & 8) != 0) {
            sbuf.append("\u30e1\u30e2\u30ea\u30fc\u30aa\u30fc\u30d0\u30fc!");
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    public String getVerAVR() {
        return this.verAVR;
    }

    public void setVerAVR(String verAVR) {
        this.verAVR = verAVR;
    }

    public Date getDateAVR() {
        return this.dateAVR;
    }

    public void setDateAVR(Date dateAVR) {
        this.dateAVR = dateAVR;
    }

    public void setDateAVR(String dateAVRstr) throws ParseException {
        this.dateAVR = new SimpleDateFormat("yyyyMMdd").parse(dateAVRstr);
    }

    public String getVerMSP() {
        return this.verMSP;
    }

    public void setVerMSP(String verMSP) {
        this.verMSP = verMSP;
    }

    public String getVerType() {
        return this.verType;
    }

    public void setVerType(String verType) {
        this.verType = verType;
    }

    public Element getXmlElement(Document document) {
        String name;
        Element device = document.createElement("device");
        String idStr = this.getDeviceID();
        if (idStr != null) {
            device.setAttribute("sn", idStr);
        }
        if (this.getTypeID() != null) {
            Element type = document.createElement("type");
            type.setAttribute("id", this.getTypeID());
            type.appendChild(document.createTextNode(this.getTypeName()));
            device.appendChild(type);
        }
        if (this.getVerAVR() != null) {
            Element avr = document.createElement("AVR");
            avr.setAttribute("ver", this.getVerAVR());
            if (this.getDateAVR() != null) {
                avr.setAttribute("date", new SimpleDateFormat("yyyy/MM/dd").format(this.getDateAVR()));
            }
            device.appendChild(avr);
        }
        if (this.getVerMSP() != null) {
            Element msp = document.createElement("AVR");
            msp.setAttribute("ver", this.getVerMSP());
            if (this.getVerType() != null) {
                msp.setAttribute("type", this.getVerType());
            }
            device.appendChild(msp);
        }
        if ((name = this.getDeviceName()) != null) {
            Element nameEle = document.createElement("name");
            nameEle.appendChild(document.createTextNode(name));
            device.appendChild(nameEle);
        }
        return device;
    }
}

