/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.accessor.dbaccess.CB3JdbcDaoSupport;
import jp.co.cybec.cb3.accessor.dbaccess.DBAccessConfig;
import jp.co.cybec.cb3.accessor.dbaccess.DBAccessor;
import jp.co.cybec.cb3.accessor.dbaccess.DBQueryParameterMap;
import jp.co.cybec.cb3.accessor.dbaccess.DBRecordReader;
import jp.co.cybec.cb3.accessor.dbaccess.DeleteSql;
import jp.co.cybec.cb3.accessor.dbaccess.InsertSql;
import jp.co.cybec.cb3.accessor.dbaccess.JdbcRecordReader;
import jp.co.cybec.cb3.accessor.dbaccess.SelectSql;
import jp.co.cybec.cb3.accessor.dbaccess.UpdateSql;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileNoSuchSqlIdException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;

public class DBAccessorImpl
extends CB3JdbcDaoSupport
implements DBAccessor,
AccessorsLifeCycle {
    private static final Log LOG = LogFactory.getLog(DBAccessorImpl.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private static final String RULE_FILE = "dbaccessConfigRule.xml";
    private Map<String, String> selectSqlCache = new HashMap<String, String>();
    private Map<String, String> insertSqlCache = new HashMap<String, String>();
    private Map<String, String> updateSqlCache = new HashMap<String, String>();
    private Map<String, String> deleteSqlCache = new HashMap<String, String>();
    private Map<String, String> commitLimitCountMap = new HashMap<String, String>();
    private Map<String, Integer> commitCountMap = new HashMap<String, Integer>();

    public void initialize(String key) throws ConfigFileNotFoundException, ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {
        DBAccessConfig info = (DBAccessConfig)ConfigurationLoader.load(RULE_FILE, key);
        for (SelectSql selectSql : info.getSelectSql()) {
            this.selectSqlCache.put(selectSql.getId(), selectSql.getSelect());
        }
        for (UpdateSql updateSql : info.getUpdateSql()) {
            this.commitLimitCountMap.put(updateSql.getId(), updateSql.getCommitLimitCount());
            this.updateSqlCache.put(updateSql.getId(), updateSql.getUpdate());
        }
        for (InsertSql insertSql : info.getInsertSql()) {
            this.commitLimitCountMap.put(insertSql.getId(), insertSql.getCommitLimitCount());
            this.insertSqlCache.put(insertSql.getId(), insertSql.getInsert());
        }
        for (DeleteSql deleteSql : info.getDeleteSql()) {
            this.commitLimitCountMap.put(deleteSql.getId(), deleteSql.getCommitLimitCount());
            this.deleteSqlCache.put(deleteSql.getId(), deleteSql.getDelete());
        }
    }

    public void release() {
        this.getCB3JdbcTemplate().close();
        this.selectSqlCache.clear();
        this.updateSqlCache.clear();
        this.insertSqlCache.clear();
        this.deleteSqlCache.clear();
        this.commitLimitCountMap.clear();
        this.commitCountMap.clear();
    }

    public DBRecordReader select(String key, DBQueryParameterMap parameter) throws DataFileNoSuchSqlIdException, DataAccessException {
        String sql = this.selectSqlCache.get(key);
        if (sql == null || "".equals(sql)) {
            DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.006", "CB3.ACCESSOR.DBACCESS.011", key, "select"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        ResultSet rs = this.getCB3JdbcTemplate().query(sql, parameter);
        JdbcRecordReader recordReader = new JdbcRecordReader(rs, sql, parameter);
        return recordReader;
    }

    public DBRecordReader select(String key) throws DataFileNoSuchSqlIdException, DataAccessException {
        String sql = this.selectSqlCache.get(key);
        if (sql == null || "".equals(sql)) {
            DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.007", "CB3.ACCESSOR.DBACCESS.011", key, "select"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        ResultSet rs = this.getCB3JdbcTemplate().query(sql);
        JdbcRecordReader recordReader = new JdbcRecordReader(rs, sql);
        return recordReader;
    }

    public int update(String key, DBQueryParameterMap parameter) throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {
        String sql = this.updateSqlCache.get(key);
        if (sql == null || "".equals(sql)) {
            DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.008", "CB3.ACCESSOR.DBACCESS.011", key, "update"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            int rtCnt = this.getCB3JdbcTemplate().update(sql, parameter);
            this.divideCommit(key, rtCnt);
            return rtCnt;
        }
        catch (DataAccessException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] msg = new Object[]{sql, parameter};
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.009", "CB3.ACCESSOR.DBACCESS.009", msg), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public int update(String key) throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {
        String sql = this.updateSqlCache.get(key);
        if (sql == null || "".equals(sql)) {
            DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.010", "CB3.ACCESSOR.DBACCESS.011", key, "update"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            int rtCnt = this.getCB3JdbcTemplate().update(sql);
            this.divideCommit(key, rtCnt);
            return rtCnt;
        }
        catch (DataAccessException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] msg = new Object[]{sql, ""};
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.011", "CB3.ACCESSOR.DBACCESS.009", msg), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public int delete(String key, DBQueryParameterMap parameter) throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {
        String sql = this.deleteSqlCache.get(key);
        if (sql == null || "".equals(sql)) {
            DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.012", "CB3.ACCESSOR.DBACCESS.011", key, "delete"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            int rtCnt = this.getCB3JdbcTemplate().update(sql, parameter);
            this.divideCommit(key, rtCnt);
            return rtCnt;
        }
        catch (DataAccessException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] msg = new Object[]{sql, parameter};
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.013", "CB3.ACCESSOR.DBACCESS.010", msg), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public int delete(String key) throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {
        String sql = this.deleteSqlCache.get(key);
        if (sql == null || "".equals(sql)) {
            DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.014", "CB3.ACCESSOR.DBACCESS.011", key, "delete"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            int rtCnt = this.getCB3JdbcTemplate().update(sql);
            this.divideCommit(key, rtCnt);
            return rtCnt;
        }
        catch (DataAccessException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] msg = new Object[]{sql, ""};
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.015", "CB3.ACCESSOR.DBACCESS.010", msg), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public int insert(String key, DBQueryParameterMap parameter) throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {
        String sql = this.insertSqlCache.get(key);
        if (sql == null || "".equals(sql)) {
            DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.016", "CB3.ACCESSOR.DBACCESS.011", key, "insert"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            int rtCnt = this.getCB3JdbcTemplate().update(sql, parameter);
            this.divideCommit(key, rtCnt);
            return rtCnt;
        }
        catch (DataAccessException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] msg = new Object[]{sql, parameter};
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.017", "CB3.ACCESSOR.DBACCESS.008", msg), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public int insert(String key) throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {
        String sql = this.insertSqlCache.get(key);
        if (sql == null || "".equals(sql)) {
            DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.018", "CB3.ACCESSOR.DBACCESS.011", key, "insert"));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            int rtCnt = this.getCB3JdbcTemplate().update(sql);
            this.divideCommit(key, rtCnt);
            return rtCnt;
        }
        catch (DataAccessException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] msg = new Object[]{sql, ""};
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.DBACCESS.019", "CB3.ACCESSOR.DBACCESS.008", msg), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    private void divideCommit(String key, int count) {
        String cmtLimitCnt = this.commitLimitCountMap.get(key);
        Integer cmtCount = this.commitCountMap.get(key);
        if (cmtCount == null) {
            cmtCount = 0;
        }
        if (cmtLimitCnt != null && !"".equals(cmtLimitCnt)) {
            if ((cmtCount = Integer.valueOf(cmtCount + count)) >= Integer.parseInt(cmtLimitCnt)) {
                this.getCB3JdbcTemplate().commit();
                cmtCount = 0;
            }
            this.commitCountMap.put(key, cmtCount);
        }
    }
}

