/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess;

import java.util.Arrays;
import java.util.Date;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldWriterFormatable;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.DateUtil;
import jp.co.cybec.cb3.util.NumberUtil;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordFieldWriterFormat
implements RecordFieldWriterFormatable {
    private static final Log LOG = LogFactory.getLog(RecordFieldWriterFormat.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String filepath = null;
    private String field = null;

    public RecordFieldWriterFormat(String filepath, String field) {
        this.filepath = filepath;
        this.field = field;
    }

    public String format(String pattern, String type, String data) throws DataFormatException {
        String retValue = null;
        if (data == null || data.trim().length() == 0) {
            return data;
        }
        if (pattern == null || pattern.length() == 0) {
            return data;
        }
        if (type == null || !type.equalsIgnoreCase("number") && !type.equalsIgnoreCase("date")) {
            String messageId = "CB3.ACCESSOR.FILEACCESS.008";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.005", messageId, this.filepath, this.field, type));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            if (type.equalsIgnoreCase("number")) {
                retValue = NumberUtil.formatNumber(pattern, data);
            } else {
                Date date = DateUtil.parseDate(data);
                retValue = DateUtil.formatDate(date, pattern);
            }
        }
        catch (Exception e) {
            String messageId = "CB3.ACCESSOR.FILEACCESS.007";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.006", messageId, this.field, data, pattern));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        return retValue;
    }

    public String padding(String length, String algin, String padding, String data) throws DataFormatException {
        int iLength;
        if (data == null) {
            data = new String();
        }
        if (length == null || length.trim().length() == 0 || algin == null || algin.trim().length() == 0 || padding == null || padding.length() == 0) {
            return data;
        }
        if (!algin.equalsIgnoreCase("left") && !algin.equalsIgnoreCase("right")) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.007", "CB3.ACCESSOR.FILEACCESS.011", this.filepath, this.field, algin));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        if (padding.getBytes().length > 1) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.008", "CB3.ACCESSOR.FILEACCESS.012", this.filepath, this.field, padding));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            iLength = Integer.parseInt(length);
        }
        catch (NumberFormatException e) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.009", "CB3.ACCESSOR.FILEACCESS.012", this.filepath, this.field, length));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        if (data.getBytes().length > iLength) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.010", "CB3.ACCESSOR.FILEACCESS.014", data, this.filepath, this.field, length));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        char[] dataCharArr = data.toCharArray();
        int retCharLength = iLength - (data.getBytes().length - dataCharArr.length);
        char[] retCharArr = new char[retCharLength];
        Arrays.fill(retCharArr, padding.charAt(0));
        if (algin.equalsIgnoreCase("left")) {
            System.arraycopy(dataCharArr, 0, retCharArr, 0, dataCharArr.length);
        } else {
            System.arraycopy(dataCharArr, 0, retCharArr, retCharArr.length - dataCharArr.length, dataCharArr.length);
        }
        return String.valueOf(retCharArr);
    }
}

