/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLAttribute {
    private static final Log LOG = LogFactory.getLog(XMLAttribute.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String name = null;
    private String value = null;
    private String uri = "";
    private String qName = "";
    private String element = null;
    private String key = null;
    private String path = null;

    public XMLAttribute(String name, Object value) {
        this(name, value, null, null, null);
    }

    protected XMLAttribute(String name, Object value, String element, String key, String path) {
        this.name = name;
        this.value = value != null ? value.toString() : null;
        this.element = element;
        this.key = key;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getString() {
        return this.value;
    }

    public Integer getInteger() throws DataFormatException {
        try {
            return Integer.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.XML.004" : "CB3.ACCESSOR.FILEACCESS.XML.005";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.001", messageId, this.name, this.value, this.element, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public Long getLong() throws DataFormatException {
        try {
            return Long.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.XML.004" : "CB3.ACCESSOR.FILEACCESS.XML.005";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.002", messageId, this.name, this.value, this.element, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public Float getFloat() throws DataFormatException {
        try {
            return Float.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.XML.004" : "CB3.ACCESSOR.FILEACCESS.XML.005";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.003", messageId, this.name, this.value, this.element, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public Short getShort() throws DataFormatException {
        try {
            return Short.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.XML.004" : "CB3.ACCESSOR.FILEACCESS.XML.005";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.004", messageId, this.name, this.value, this.element, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public BigDecimal getBigDecimal() throws DataFormatException {
        try {
            return new BigDecimal(this.value);
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.XML.004" : "CB3.ACCESSOR.FILEACCESS.XML.005";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.005", messageId, this.name, this.value, this.element, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public Date getDate() throws DataFormatException {
        try {
            return DateFormat.getDateInstance().parse(this.value);
        }
        catch (ParseException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.XML.004" : "CB3.ACCESSOR.FILEACCESS.XML.005";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.006", messageId, this.name, this.value, this.element, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getQName() {
        return this.qName;
    }

    public void setQName(String qName) {
        this.qName = qName;
    }

    public String toString() {
        return this.value;
    }
}

