/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttribute;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttributes;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLElement {
    private static final Log LOG = LogFactory.getLog(XMLElement.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String name = null;
    private String value = null;
    private String uri = "";
    private String qName = "";
    private XMLAttributes attributes = new XMLAttributes();
    private String key = null;
    private String path = null;

    public XMLElement(String name) {
        this(name, null, null);
    }

    protected XMLElement(String name, String key, String path) {
        this.name = name;
        this.key = key;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getString() {
        return this.value;
    }

    public void setString(String value) {
        this.value = value;
    }

    public Integer getInteger() throws DataFormatException {
        try {
            return this.value != null ? Integer.valueOf(this.value) : null;
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.005" : "CB3.ACCESSOR.FILEACCESS.XML.003";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.007", messageId, this.name, this.value, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void setInteger(Integer value) {
        this.value = value != null ? value.toString() : null;
    }

    public Long getLong() throws DataFormatException {
        try {
            return this.value != null ? Long.valueOf(this.value) : null;
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.005" : "CB3.ACCESSOR.FILEACCESS.XML.003";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.008", messageId, this.name, this.value, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void setLong(Long value) {
        this.value = value != null ? value.toString() : null;
    }

    public Float getFloat() throws DataFormatException {
        try {
            return this.value != null ? Float.valueOf(this.value) : null;
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.005" : "CB3.ACCESSOR.FILEACCESS.XML.003";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.009", messageId, this.name, this.value, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void setFloat(Float value) {
        this.value = value != null ? value.toString() : null;
    }

    public Short getShort() throws DataFormatException {
        try {
            return this.value != null ? Short.valueOf(this.value) : null;
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.005" : "CB3.ACCESSOR.FILEACCESS.XML.003";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.010", messageId, this.name, this.value, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void setShort(Short value) {
        this.value = value != null ? value.toString() : null;
    }

    public BigDecimal getBigDecimal() throws DataFormatException {
        try {
            return this.value != null ? new BigDecimal(this.value) : null;
        }
        catch (NumberFormatException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.005" : "CB3.ACCESSOR.FILEACCESS.XML.003";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.011", messageId, this.name, this.value, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void setBigDecimal(BigDecimal value) {
        this.value = value != null ? value.toString() : null;
    }

    public Date getDate() throws DataFormatException {
        try {
            return this.value != null ? DateFormat.getDateInstance().parse(this.value) : null;
        }
        catch (ParseException e) {
            String messageId = this.key == null ? "CB3.ACCESSOR.FILEACCESS.005" : "CB3.ACCESSOR.FILEACCESS.XML.003";
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.012", messageId, this.name, this.value, this.key, this.path));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public void setDate(Date value) {
        this.value = value != null ? DateFormat.getDateInstance().format(value) : null;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getQName() {
        return this.qName;
    }

    public void setQName(String qName) {
        this.qName = qName;
    }

    public XMLAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(XMLAttributes attributes) {
        this.attributes = attributes;
    }

    public void putAttribute(XMLAttribute attribute) {
        this.attributes.putAttribute(attribute);
    }

    public String toString() {
        return this.value;
    }
}

