/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.aspect;

import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;

public class ServiceLoggingAspect {
    private static final Log LOG = LogFactory.getLog(ServiceLoggingAspect.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");

    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        String className = pjp.getTarget().getClass().getName();
        Object[] args = pjp.getArgs();
        long beforeTime = System.currentTimeMillis();
        LOG.info((Object)MESSAGE.getMessage("CB3.ASPECT.003", className, args[1]));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MESSAGE.getMessage("CB3.ASPECT.006", args[0]));
        }
        Integer returnCode = (Integer)pjp.proceed();
        long afterTime = System.currentTimeMillis();
        long execTime = afterTime - beforeTime;
        LOG.info((Object)MESSAGE.getMessage("CB3.ASPECT.004", className, returnCode, execTime));
        return returnCode;
    }
}

