/*
 * DelimitedLineSample1.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.sample.file.delimited;

import java.util.HashMap;

import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecord;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordReader;
import jp.co.cybec.cb3.accessor.fileaccess.flat.FlatFileRecordWriter;
import jp.co.cybec.cb3.container.service.CB3Service;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;

/**
 * ϒt@CANZX̃TvNXB
 *
 * @author Teruhisa Abe
 */

public class DelimitedLineSample1 extends CB3Service {

	/**
	 * ϒt@C݂̏Ɠǂݍ݂sB
	 */
	@Override
	protected int doService(ServiceParameters serviceparameters,
			RuntimeParameters runtimeparameters) throws ServiceException {
		fileWrite();
		fileRead();
		return 0;
	}

	/**
	 * t@Cւ݂̏s
	 */
	private void fileWrite(){
		FlatFileRecordWriter writer = (FlatFileRecordWriter)getDataAccessContext().lookup("writerConfig1");
		// t@CI[v
		writer.open();

		// ǉf[^ݒ肷
		HashMap<String, String> data = new HashMap<String, String>();
		data.put("name","tanaka");
		data.put("staffId","11");
		// datȅꍇ̓ftHǧ`Őݒs yyyy/MM/dd HH:mm:ss
		data.put("registrationDate","2008/01/01 00:00:00");

		// s̃f[^ǉR[h𐶐
		FlatFileRecord record = writer.createFlatFileRecord(data);

		// t@C֏
		writer.write(record);

		// t@CN[Y
		writer.close();
	}

	/**
	 * t@C̓ǂݍ݂s
	 */
	private void fileRead(){
		FlatFileRecordReader reader = (FlatFileRecordReader)getDataAccessContext().lookup("readerConfig1");
		// ǂݍރt@CI[v
		reader.open();

		FlatFileRecord record = null;
		System.out.println("ǂݍ݌:delimitedtest1.txt");

		while((record = reader.nextRecord()) != null ){
			System.out.println("name:" + record.getString("name"));
			System.out.println("staffId:" + record.getString("staffId"));
			System.out.println("registrationDate:" + record.getString("registrationDate"));
		}
	}
}
