/*
 * Decompiled with CFR 0.152.
 */
package cfdoc.parser;

import cfdoc.parser.CfArgument;
import cfdoc.parser.CfComment;
import cfdoc.parser.CfComponent;
import cfdoc.parser.CfElement;
import cfdoc.parser.CfFile;
import cfdoc.parser.CfFunction;
import cfdoc.parser.CfNode;
import cfdoc.parser.CfParserException;
import cfdoc.parser.CfScanner;
import cfdoc.parser.CfSystem;
import cfdoc.parser.ScannerPosition;
import cfdoc.util.Logger;
import java.io.File;
import java.util.ArrayList;

public class CfParser {
    private static Logger logger;
    private CfScanner parser = new CfScanner();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setDefaultEncoding(String encoding) {
        this.parser.defaultEncoding = encoding;
    }

    public CfSystem parseDir(File basedir) throws CfParserException {
        ArrayList files = this.collectFile(basedir);
        return this.parseFiles(basedir, files);
    }

    public CfSystem parseFiles(File basedir, ArrayList files) throws CfParserException {
        CfSystem system = new CfSystem();
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            logger.info(file);
            this.parseFile(file, basedir, system);
        }
        return system;
    }

    public void parseFile(File file, File basedir, CfSystem system) throws CfParserException {
        if (file.getName().endsWith(".cfc")) {
            this.parseCfc(file, basedir, system);
        } else if (file.getName().endsWith(".cfm")) {
            this.parseCfm(file, basedir, system);
        } else {
            System.out.println("cfc, cfm\u3067\u306f\u3042\u308a\u307e\u305b\u3093:" + file);
        }
    }

    public void parseCfc(File file, File basedir, CfSystem system) throws CfParserException {
        logger.debug(file);
        CfFile cffile = this.parser.parse(file, basedir);
        system.addFile(cffile);
        CfComponent comp = null;
        CfFunction func = null;
        CfComment comment = null;
        for (int i = 0; i < cffile.taglist.size(); ++i) {
            CfElement elem;
            CfNode node = (CfNode)cffile.taglist.get(i);
            if (node instanceof CfComment) {
                comment = (CfComment)node;
                if (comp != null && comp.comment == null && func == null) {
                    comp.comment = comment;
                }
            }
            if (this.isElement(node, "cfcomponent")) {
                elem = (CfElement)node;
                if (elem.type == "OPEN") {
                    comp = new CfComponent(cffile, elem.attrMap);
                    cffile.addComponent(comp);
                } else {
                    system.addComponent(comp);
                }
            }
            if (this.isElement(node, "cffunction")) {
                elem = (CfElement)node;
                if (elem.type == "OPEN") {
                    String name = elem.getAttributeValue("name");
                    func = new CfFunction(name, elem.attrMap, cffile, comp, comment);
                    comp.addFunction(func);
                    system.addFunction(func);
                    cffile.addFunction(func);
                }
                comment = null;
            }
            if (!this.isElement(node, "cfargument")) continue;
            elem = (CfElement)node;
            CfArgument arg = new CfArgument(elem.attrMap, comment);
            comment = null;
            if (func == null) {
                throw new CfParserException("cffunction \u30bf\u30b0\u304c\u3042\u308a\u307e\u305b\u3093", new ScannerPosition(file));
            }
            func.addArgument(arg);
        }
    }

    public void parseCfm(File file, File basedir, CfSystem system) throws CfParserException {
        logger.debug(file);
        CfFile cffile = this.parser.parse(file, basedir);
        system.addFile(cffile);
        CfFunction func = null;
        CfComment comment = null;
        for (int i = 0; i < cffile.taglist.size(); ++i) {
            CfElement elem;
            CfNode node = (CfNode)cffile.taglist.get(i);
            if (node instanceof CfComment) {
                comment = (CfComment)node;
            }
            if (this.isElement(node, "cffunction")) {
                elem = (CfElement)node;
                if (elem.type == "OPEN") {
                    String name = elem.getAttributeValue("name");
                    func = new CfFunction(name, elem.attrMap, cffile, null, comment);
                    system.addFunction(func);
                    cffile.addFunction(func);
                }
                comment = null;
            }
            if (!this.isElement(node, "cfargument")) continue;
            elem = (CfElement)node;
            CfArgument arg = new CfArgument(elem.attrMap, comment);
            comment = null;
            if (func == null) {
                throw new CfParserException("cffunction \u30bf\u30b0\u304c\u3042\u308a\u307e\u305b\u3093", new ScannerPosition(file));
            }
            func.addArgument(arg);
        }
    }

    boolean isElement(CfNode node, String name) {
        if (!(node instanceof CfElement)) {
            return false;
        }
        CfElement elem = (CfElement)node;
        return elem.tagname.equalsIgnoreCase(name);
    }

    public ArrayList collectFile(File dir) {
        if (!$assertionsDisabled && dir == null) {
            throw new AssertionError();
        }
        ArrayList<File> filelist = new ArrayList<File>();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                filelist.addAll(this.collectFile(files[i]));
                continue;
            }
            String fname = files[i].getName();
            if (!fname.endsWith(".cfc") && !fname.endsWith(".cfm")) continue;
            filelist.add(files[i]);
        }
        return filelist;
    }

    static {
        $assertionsDisabled = !CfParser.class.desiredAssertionStatus();
        logger = Logger.getLogger(CfParser.class);
    }
}

